/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes.gui;

import com.redeem.redeemcodes.CodeExpirationManager;
import com.redeem.redeemcodes.Redeemcodes;
import com.redeem.redeemcodes.gui.CodeEditorGUI;
import com.redeem.redeemcodes.gui.ExpiredCodesListGUI;
import com.redeem.redeemcodes.gui.HeadManager;
import com.redeem.redeemcodes.gui.MainGUI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CodesListGUI {
    private final Redeemcodes plugin;
    private List<String> codes;
    private int page = 0;
    private static final int TOTAL_SIZE = 54;
    private static final int COLUMNS = 7;
    private static final int ROW_START = 1;
    private static final int ROW_END = 4;
    private static final int CODES_PER_PAGE = 28;
    private static final String pro = "\u00a7x\u00a72\u00a7D\u00a79\u00a7D\u00a7F\u00a7F\u00a7l| ";
    private static final String titleColor = "\u00a7x\u00a72\u00a7D\u00a79\u00a7D\u00a7F\u00a7F";
    private static final String pro_expired = "\u00a7x\u00a7F\u00a7F\u00a77\u00a70\u00a77\u00a70\u00a7l| ";
    private static final String titleColor_expired = "\u00a7c";

    public CodesListGUI(Redeemcodes plugin) {
        this.plugin = plugin;
    }

    public void open(Player player) {
        ItemStack pageDisplay;
        ItemMeta pageMeta;
        int index;
        int end;
        int start;
        this.plugin.reloadCodesConfig();
        Set codeKeys = this.plugin.getCodesConfig().getConfigurationSection("Codes").getKeys(false);
        this.codes = new ArrayList<String>();
        CodeExpirationManager expManager = this.plugin.getExpirationManager();
        for (String code : codeKeys) {
            if (expManager.isExpired(code)) continue;
            this.codes.add(code);
        }
        Inventory inv = Bukkit.createInventory((InventoryHolder)null, (int)54, (String)(String.valueOf(ChatColor.DARK_PURPLE) + "\u00a7x\u00a72\u00a7B\u00a78\u00a76\u00a7D\u00a77Redeem Codes"));
        ItemStack border = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta borderMeta = border.getItemMeta();
        if (borderMeta != null) {
            borderMeta.setDisplayName(" ");
        }
        border.setItemMeta(borderMeta);
        for (start = 0; start < 54; ++start) {
            end = start / 9;
            index = start % 9;
            if (end != 0 && end != 5 && index != 0 && index != 8) continue;
            inv.setItem(start, border);
        }
        start = this.page * 28;
        end = Math.min(start + 28, this.codes.size());
        index = 0;
        for (int row = 1; row <= 4 && start + index < end; ++row) {
            for (int col = 1; col <= 7 && start + index < end; ++col) {
                int slot = row * 9 + col;
                inv.setItem(slot, this.createCodeHead(this.codes.get(start + index)));
                ++index;
            }
        }
        if (this.page > 0) {
            inv.setItem(45, HeadManager.getHead("PREV_PAGE", String.valueOf(ChatColor.GRAY) + "Previous Page", new String[0]));
        }
        inv.setItem(47, HeadManager.getHead("EXPIRED_LIST", "\u00a7x\u00a7F\u00a7B\u00a7F\u00a72\u00a76\u00a7DE\u00a7x\u00a7F\u00a7B\u00a7F\u00a73\u00a77\u00a74x\u00a7x\u00a7F\u00a7C\u00a7F\u00a73\u00a77\u00a7Ap\u00a7x\u00a7F\u00a7C\u00a7F\u00a74\u00a78\u00a71i\u00a7x\u00a7F\u00a7C\u00a7F\u00a75\u00a78\u00a78r\u00a7x\u00a7F\u00a7D\u00a7F\u00a76\u00a78\u00a7Fe\u00a7x\u00a7F\u00a7D\u00a7F\u00a76\u00a79\u00a75d \u00a7x\u00a7F\u00a7E\u00a7F\u00a77\u00a79\u00a7CC\u00a7x\u00a7F\u00a7E\u00a7F\u00a78\u00a7A\u00a73o\u00a7x\u00a7F\u00a7E\u00a7F\u00a79\u00a7A\u00a7Ad\u00a7x\u00a7F\u00a7F\u00a7F\u00a79\u00a7B\u00a70e\u00a7x\u00a7F\u00a7F\u00a7F\u00a7A\u00a7B\u00a77s", "\u00a77\u1d04\u029f\u026a\u1d04\u1d0b \u1d1b\u1d0f \u1d20\u026a\u1d07\u1d21 \u1d00\u029f\u029f \u1d07x\u1d18\u026a\u0280\u1d07\u1d05 \u1d04\u1d0f\u1d05\u1d07\ua731"));
        inv.setItem(49, HeadManager.getHead("BACK", String.valueOf(ChatColor.RED) + "Go Back", "\u00a7x\u00a7A\u00a72\u00a7A\u00a72\u00a7A\u00a72\u1d04\u00a7x\u00a7A\u00a75\u00a7A\u00a75\u00a7A\u00a75\u029f\u00a7x\u00a7A\u00a78\u00a7A\u00a78\u00a7A\u00a78\u026a\u00a7x\u00a7A\u00a7A\u00a7A\u00a7A\u00a7A\u00a7A\u1d04\u00a7x\u00a7A\u00a7D\u00a7A\u00a7D\u00a7A\u00a7D\u1d0b \u00a7x\u00a7B\u00a70\u00a7B\u00a70\u00a7B\u00a70\u1d1b\u00a7x\u00a7B\u00a73\u00a7B\u00a73\u00a7B\u00a73\u1d0f \u00a7x\u00a7B\u00a76\u00a7B\u00a76\u00a7B\u00a76\u0262\u00a7x\u00a7B\u00a79\u00a7B\u00a79\u00a7B\u00a79\u1d0f \u00a7x\u00a7B\u00a7B\u00a7B\u00a7B\u00a7B\u00a7B\u0299\u00a7x\u00a7B\u00a7E\u00a7B\u00a7E\u00a7B\u00a7E\u1d00\u00a7x\u00a7C\u00a71\u00a7C\u00a71\u00a7C\u00a71\u1d04\u00a7x\u00a7C\u00a74\u00a7C\u00a74\u00a7C\u00a74\u1d0b \u00a7x\u00a7C\u00a77\u00a7C\u00a77\u00a7C\u00a77\u1d1b\u00a7x\u00a7C\u00a79\u00a7C\u00a79\u00a7C\u00a79\u1d0f \u00a7x\u00a7C\u00a7C\u00a7C\u00a7C\u00a7C\u00a7C\u1d0d\u00a7x\u00a7C\u00a7F\u00a7C\u00a7F\u00a7C\u00a7F\u1d00\u00a7x\u00a7D\u00a72\u00a7D\u00a72\u00a7D\u00a72\u026a\u00a7x\u00a7D\u00a75\u00a7D\u00a75\u00a7D\u00a75\u0274 \u00a7x\u00a7D\u00a78\u00a7D\u00a78\u00a7D\u00a78\u1d0d\u00a7x\u00a7D\u00a7A\u00a7D\u00a7A\u00a7D\u00a7A\u1d07\u00a7x\u00a7D\u00a7D\u00a7D\u00a7D\u00a7D\u00a7D\u0274\u00a7x\u00a7E\u00a70\u00a7E\u00a70\u00a7E\u00a70\u1d1c"));
        if (end < this.codes.size()) {
            inv.setItem(53, HeadManager.getHead("NEXT_PAGE", String.valueOf(ChatColor.GRAY) + "Next Page", new String[0]));
        }
        if ((pageMeta = (pageDisplay = new ItemStack(Material.PAPER)).getItemMeta()) != null) {
            int maxPage = this.codes.isEmpty() ? 1 : (this.codes.size() - 1) / 28 + 1;
            pageMeta.setDisplayName("Page: \u00a7x\u00a72\u00a7D\u00a79\u00a7D\u00a7F\u00a7F" + (this.page + 1) + "/" + maxPage);
            pageDisplay.setItemMeta(pageMeta);
        }
        inv.setItem(48, pageDisplay);
        player.openInventory(inv);
    }

    private ItemStack createCodeHead(String code) {
        boolean isExpired = this.plugin.getExpirationManager().isExpired(code);
        String currentPro = isExpired ? pro_expired : pro;
        String currentTitleColor = isExpired ? titleColor_expired : titleColor;
        String currentValueColor = isExpired ? "\u00a7e" : "\u00a7b";
        String headKey = isExpired ? "EXPIRED_CODE_ITEM" : "CODE_ITEM";
        ItemStack head = HeadManager.getHead(headKey, currentTitleColor + code, new String[0]);
        ItemMeta meta = head.getItemMeta();
        if (meta != null) {
            ArrayList<Object> lore = new ArrayList<Object>();
            String var10001 = String.valueOf(ChatColor.GRAY);
            lore.add("");
            lore.add(currentPro + var10001 + "\u1d07\u0274\u1d00\u0299\u029f\u1d07\u1d05: " + (this.plugin.getCodesConfig().getBoolean("Codes." + code + ".enabled", true) ? String.valueOf(ChatColor.GREEN) + "Yes" : String.valueOf(ChatColor.RED) + "No"));
            var10001 = String.valueOf(ChatColor.GRAY);
            lore.add(currentPro + var10001 + "\u1d18\u1d07\u0280\u1d0d\u026a\ua731\ua731\u026a\u1d0f\u0274 \u0280\u1d07Q\u1d1c\u026a\u0280\u1d07\u1d05: " + (this.plugin.getCodesConfig().getBoolean("Codes." + code + ".permisson.required", false) ? String.valueOf(ChatColor.GREEN) + "Yes" : String.valueOf(ChatColor.RED) + "No"));
            var10001 = String.valueOf(ChatColor.GRAY);
            lore.add(currentPro + var10001 + "\u1d04\u1d0f\u1d0f\u029f\u1d05\u1d0f\u1d21\u0274: " + currentValueColor + this.plugin.getCodesConfig().getInt("Codes." + code + ".redeem-limit.Cooldown", 0) + " min");
            var10001 = String.valueOf(ChatColor.GRAY);
            lore.add(currentPro + var10001 + "\u0280\u1d07\u1d05\u1d07\u1d07\u1d0d \u1d1b\u028f\u1d18\u1d07: " + currentValueColor + this.plugin.getCodesConfig().getString("Codes." + code + ".redeem-limit.Type", "PLAYER"));
            var10001 = String.valueOf(ChatColor.GRAY);
            lore.add(currentPro + var10001 + "\u0280\u1d07\u1d05\u1d07\u1d07\u1d0d \u029f\u026a\u1d0d\u026a\u1d1b: " + currentValueColor + this.plugin.getCodesConfig().getInt("Codes." + code + ".redeem-limit.Count", 1));
            CodeExpirationManager expManager = this.plugin.getExpirationManager();
            if (isExpired) {
                lore.add(currentPro + "\u00a7cEXPIRED");
            }
            lore.add(currentPro + String.valueOf(ChatColor.GRAY) + "\u0280\u1d07\u1d21\u1d00\u0280\u1d05\ua731:");
            List rewards = this.plugin.getCodesConfig().getStringList("Codes." + code + ".rewards");
            if (rewards.isEmpty()) {
                lore.add(String.valueOf(ChatColor.RED) + "- No rewards set");
            } else {
                for (int i = 0; i < rewards.size(); ++i) {
                    var10001 = currentValueColor;
                    lore.add(var10001 + "  #" + i + ": " + String.valueOf(ChatColor.GRAY) + (String)rewards.get(i));
                }
            }
            meta.setLore(lore);
            head.setItemMeta(meta);
        }
        return head;
    }

    public void handleClick(InventoryClickEvent event, Player player) {
        if (!event.getView().getTitle().contains("Redeem Codes") || event.getView().getTitle().contains("Expired")) {
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || !clickedItem.hasItemMeta() || !clickedItem.getItemMeta().hasDisplayName()) {
            return;
        }
        String itemName = ChatColor.stripColor((String)clickedItem.getItemMeta().getDisplayName());
        if (itemName.equals("Go Back")) {
            player.closeInventory();
            MainGUI.open(player);
        } else if (itemName.equals("Next Page")) {
            if ((this.page + 1) * 28 < this.codes.size()) {
                ++this.page;
                this.open(player);
            }
        } else if (itemName.equals("Previous Page")) {
            if (this.page > 0) {
                --this.page;
                this.open(player);
            }
        } else if (itemName.equals("Expired Codes")) {
            ExpiredCodesListGUI expiredGUI = new ExpiredCodesListGUI(this.plugin, this);
            this.plugin.openExpiredCodeGUIs.put(player, expiredGUI);
            expiredGUI.open(player);
        } else if (this.codes.contains(itemName)) {
            CodeEditorGUI editor = new CodeEditorGUI(this.plugin, itemName, this);
            this.plugin.openEditorGUIs.put(player, editor);
            editor.open(player);
        }
    }
}

