/*
 * Decompiled with CFR 0.152.
 */
package com.redeem.redeemcodes.gui;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class HeadManager {
    private static final Map<String, ItemStack> cachedHeads = new HashMap<String, ItemStack>();
    private static final Map<String, UUID> headUUIDs = new HashMap<String, UUID>();

    public static void preloadHeads() {
        HeadManager.register("CREATE", "ab478a4b2622ee44e81ad019f5302985659de8c382d29f0ef21e993d43d87d3");
        HeadManager.register("LIST", "6f9c7e59a2cebc0584f3bf71bbdaaf199c4921c2310723efdcb4eb6bcb9a13fc");
        HeadManager.register("ADMIN", "cfd3f7d43d360923b1c04445b01022466b50ca58df9893267121081e0c1e2f4e");
        HeadManager.register("CLOSE", "beb588b21a6f98ad1ff4e085c552dcb050efc9cab427f46048f18fc803475f7");
        HeadManager.register("CODE_ITEM", "ca18def035f87f7616404978208926be7476b579dfa360f0c2269ef2d4029c");
        HeadManager.register("BACK", "223fb67429716b21bc6e8e7d669ceddf65b13e0790a5ce55b2e077b82d19e124");
        HeadManager.register("NEXT_PAGE", "8271a47104495e357c3e8e80f511a9f102b0700ca9b88e88b795d33ff20105eb");
        HeadManager.register("PREV_PAGE", "69ea1d86247f4af351ed1866bca6a3040a06c68177c78e42316a1098e60fb7d3");
        HeadManager.register("EXPIRE_TIME", "85fa0a3a2d62d7d1171d48b3ae8fcb551f6faccc70cee40f44c767c3da7b785f");
        HeadManager.register("REACTIVATE", "ca50b3b3bf82165645a9335817b46de933e8b92a58304dc591b98d6033404447");
        HeadManager.register("EXPIRED_LIST", "85fa0a3a2d62d7d1171d48b3ae8fcb551f6faccc70cee40f44c767c3da7b785f");
        HeadManager.register("EXPIRED_CODE_ITEM", "266d513dd1a03655af361ce5fd3e66b890b2b8866f0ebd14a82e9e6568d7db86");
    }

    public static Map<String, ItemStack> getAllCachedHeads() {
        return new HashMap<String, ItemStack>(cachedHeads);
    }

    private static void register(String key, String textureId) {
        UUID consistentUUID = headUUIDs.computeIfAbsent(key, k -> UUID.nameUUIDFromBytes(k.getBytes(StandardCharsets.UTF_8)));
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta != null) {
            try {
                PlayerProfile profile = Bukkit.createProfile((UUID)consistentUUID, null);
                ProfileProperty skinProperty = new ProfileProperty("textures", Base64.getEncoder().encodeToString(("{\"timestamp\":1,\"profileId\":\"00000000-0000-0000-0000-000000000000\",\"profileName\":\"NPC\",\"textures\":{\"SKIN\":{\"url\":\"https://textures.minecraft.net/texture/" + textureId + "\"}}}").getBytes()));
                profile.setProperty(skinProperty);
                meta.setPlayerProfile(profile);
                head.setItemMeta((ItemMeta)meta);
                System.out.println("[RedeemCodes] Successfully loaded head texture for key: " + key);
            }
            catch (Exception e) {
                System.err.println("[RedeemCodes] ERROR: Failed to load head texture for key '" + key + "' - " + e.getMessage());
            }
        } else {
            System.err.println("[RedeemCodes] ERROR: Failed to get SkullMeta for key '" + key + "'");
        }
        cachedHeads.put(key, head);
    }

    private static void registerBase64(String key, String base64Texture) {
        ItemStack head;
        block12: {
            head = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)head.getItemMeta();
            if (meta != null) {
                try {
                    String decodedTexture = new String(Base64.getDecoder().decode(base64Texture));
                    System.out.println("[RedeemCodes] DEBUG: Decoded Base64 for '" + key + "': " + decodedTexture);
                    String textureUrl = null;
                    if (decodedTexture.contains("\"url\":\"")) {
                        start = decodedTexture.indexOf("\"url\":\"") + 7;
                        end = decodedTexture.indexOf("\"", start);
                        if (end > start) {
                            textureUrl = decodedTexture.substring(start, end);
                        }
                    } else if (decodedTexture.contains("url:")) {
                        start = decodedTexture.indexOf("url:") + 4;
                        end = decodedTexture.indexOf("\"", start);
                        if (end == -1) {
                            end = decodedTexture.indexOf("}", start);
                        }
                        if (end > start) {
                            textureUrl = decodedTexture.substring(start, end).replace("\"", "").trim();
                        }
                    }
                    if (textureUrl != null && !textureUrl.isEmpty()) {
                        System.out.println("[RedeemCodes] DEBUG: Extracted texture URL for '" + key + "': " + textureUrl);
                        UUID consistentUUID = headUUIDs.computeIfAbsent(key, k -> UUID.nameUUIDFromBytes(k.getBytes(StandardCharsets.UTF_8)));
                        PlayerProfile profile = Bukkit.createProfile((UUID)consistentUUID, null);
                        ProfileProperty skinProperty = new ProfileProperty("textures", Base64.getEncoder().encodeToString(("{\"timestamp\":1,\"profileId\":\"00000000-0000-0000-0000-000000000000\",\"profileName\":\"NPC\",\"textures\":{\"SKIN\":{\"url\":\"" + textureUrl + "\"}}}").getBytes()));
                        profile.setProperty(skinProperty);
                        meta.setPlayerProfile(profile);
                        head.setItemMeta((ItemMeta)meta);
                        System.out.println("[RedeemCodes] Successfully loaded Base64 head texture for key: " + key);
                        break block12;
                    }
                    System.err.println("[RedeemCodes] ERROR: Failed to parse texture URL from Base64 for key '" + key + "' - URL is null or empty");
                    System.err.println("[RedeemCodes] DEBUG: Decoded content: " + decodedTexture);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("[RedeemCodes] ERROR: Invalid Base64 format for key '" + key + "' - " + e.getMessage());
                }
                catch (Exception e) {
                    System.err.println("[RedeemCodes] ERROR: Failed to load Base64 head texture for key '" + key + "' - " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                System.err.println("[RedeemCodes] ERROR: Failed to get SkullMeta for Base64 key '" + key + "'");
            }
        }
        cachedHeads.put(key, head);
    }

    public static ItemStack getHead(String key, String displayName, String ... lore) {
        ItemStack base = cachedHeads.get(key);
        if (base == null) {
            System.out.println("[RedeemCodes] WARN: Missing head texture for key: " + key);
            return new ItemStack(Material.PLAYER_HEAD);
        }
        ItemStack clone = base.clone();
        SkullMeta meta = (SkullMeta)clone.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(displayName);
            if (lore != null && lore.length > 0) {
                meta.setLore(Arrays.asList(lore));
            }
            clone.setItemMeta((ItemMeta)meta);
        }
        return clone;
    }
}

