/*
 * Decompiled with CFR 0.152.
 */
package dev.unowly.render;

import dev.unowly.config.TreeTimberConfig;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;

@Environment(value=EnvType.CLIENT)
public class TimberStateHudRendering {
    private static boolean timberActive = false;
    private static boolean previousState = false;
    private static long stateChangeTime = 0L;
    private static TreeTimberConfig config;

    public static void setConfig(TreeTimberConfig config) {
        TimberStateHudRendering.config = config;
    }

    public static void setTimberActive(boolean active) {
        if (timberActive != active) {
            previousState = timberActive;
            timberActive = active;
            stateChangeTime = System.currentTimeMillis();
        }
    }

    public static boolean isTimberActive() {
        return timberActive;
    }

    public static void render(class_332 context, class_9779 tickCounter) {
        float alpha;
        if (!timberActive && (config == null || TimberStateHudRendering.config.enabled)) {
            return;
        }
        if (config != null && !TimberStateHudRendering.config.enabled) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1772 == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long timeSinceChange = currentTime - stateChangeTime;
        float f = alpha = config != null && TimberStateHudRendering.config.fadeAnimation ? TimberStateHudRendering.calculateAlpha(timeSinceChange) : 1.0f;
        if (alpha <= 0.0f) {
            return;
        }
        float pulseMultiplier = 1.0f;
        if (config != null && TimberStateHudRendering.config.pulseAnimation && timberActive) {
            pulseMultiplier = TimberStateHudRendering.calculatePulse(currentTime);
        }
        String message = timberActive ? (config != null ? TimberStateHudRendering.config.activeText : "TreeTimber is ACTIVE") : (config != null ? TimberStateHudRendering.config.inactiveText : "TreeTimber is INACTIVE");
        class_327 renderer = client.field_1772;
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        int textWidth = renderer.method_1727(message);
        int xOffset = config != null ? TimberStateHudRendering.config.xOffset : 50;
        int yOffset = config != null ? TimberStateHudRendering.config.yOffset : 90;
        int x = screenWidth * xOffset / 100 - textWidth / 2;
        int y = screenHeight * yOffset / 100;
        int baseColor = timberActive ? (config != null ? TimberStateHudRendering.config.activeColor : 65280) : (config != null ? TimberStateHudRendering.config.inactiveColor : 0xFF0000);
        int color = TimberStateHudRendering.applyAlpha(baseColor, alpha);
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        float scale = (float)(config != null ? TimberStateHudRendering.config.textScale : 100) / 100.0f * pulseMultiplier;
        float centerX = (float)x + (float)renderer.method_1727(message) / 2.0f;
        float f2 = y;
        Objects.requireNonNull(renderer);
        float centerY = f2 + 9.0f / 2.0f;
        matrices.translate(centerX, centerY);
        matrices.scale(scale, scale);
        matrices.translate(-centerX, -centerY);
        int scaledX = x;
        int scaledY = y;
        if (config == null || TimberStateHudRendering.config.shadow) {
            int shadowColor = TimberStateHudRendering.applyAlpha(config != null ? TimberStateHudRendering.config.shadowColor : 0, alpha);
            context.method_51433(renderer, message, scaledX + 1, scaledY + 1, shadowColor, false);
        }
        if (config != null && TimberStateHudRendering.config.fadeAnimation) {
            TimberStateHudRendering.renderGradientText(context, renderer, message, scaledX, scaledY, alpha, currentTime);
        } else {
            context.method_51433(renderer, message, scaledX, scaledY, color, false);
        }
        matrices.popMatrix();
    }

    private static float calculateAlpha(long timeSinceChange) {
        if (config == null || !TimberStateHudRendering.config.fadeAnimation) {
            return 1.0f;
        }
        if (timberActive) {
            if (timeSinceChange < (long)TimberStateHudRendering.config.fadeInDuration) {
                return (float)timeSinceChange / (float)TimberStateHudRendering.config.fadeInDuration;
            }
            return 1.0f;
        }
        if (timeSinceChange < (long)TimberStateHudRendering.config.fadeOutDuration) {
            return 1.0f - (float)timeSinceChange / (float)TimberStateHudRendering.config.fadeOutDuration;
        }
        return 0.0f;
    }

    private static float calculatePulse(long currentTime) {
        if (config == null || TimberStateHudRendering.config.pulseSpeed <= 0) {
            return 1.0f;
        }
        double cycle = (double)(currentTime % (long)TimberStateHudRendering.config.pulseSpeed) / (double)TimberStateHudRendering.config.pulseSpeed;
        return 1.0f + 0.1f * (float)Math.sin(cycle * 2.0 * Math.PI);
    }

    private static int applyAlpha(int color, float alpha) {
        int a = (int)(255.0f * alpha);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static void renderGradientText(class_332 context, class_327 renderer, String message, int x, int y, float alpha, long time) {
        int totalWidth = renderer.method_1727(message);
        int startColor = TimberStateHudRendering.config.fadeStartColor;
        int endColor = TimberStateHudRendering.config.fadeEndColor;
        int currentX = x;
        float speed = 0.001f;
        float offset = (float)(time % 10000L) * speed;
        for (int i = 0; i < message.length(); ++i) {
            String s = String.valueOf(message.charAt(i));
            int charWidth = renderer.method_1727(s);
            float t = totalWidth == 0 ? 0.0f : ((float)(currentX - x) / (float)totalWidth + offset) % 1.0f;
            int interpolatedColor = TimberStateHudRendering.interpolateColor(startColor, endColor, t);
            int colorWithAlpha = TimberStateHudRendering.applyAlpha(interpolatedColor, alpha);
            context.method_51433(renderer, s, currentX, y, colorWithAlpha, false);
            currentX += charWidth;
        }
    }

    private static int interpolateColor(int color1, int color2, float t) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return r << 16 | g << 8 | b;
    }
}

