/*
 * Decompiled with CFR 0.152.
 */
package dev.unowly.util;

import dev.unowly.config.ModConfig;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;

public class TreeFellingUtil {
    private final Set<class_2960> woodBlockIds;

    public TreeFellingUtil(Set<class_2960> woodBlockIds) {
        this.woodBlockIds = woodBlockIds;
    }

    public void findAndBreakConnectedWood(class_3218 world, class_2338 startPos, class_1657 player, class_1799 tool) {
        if (!ModConfig.CONFIG.allowNonAxes && !this.isAxe(tool)) {
            return;
        }
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        class_2338 lowestLogPos = startPos;
        int lowestY = startPos.method_10264();
        class_2680 originalLogState = world.method_8320(startPos);
        boolean isLargeTree = this.isLargeTreeStump(world, startPos, originalLogState);
        int brokenCount = 0;
        int maxToBreak = ModConfig.CONFIG.maxLogsBrocken;
        queue.add(startPos.method_10062());
        visited.add(startPos.method_10062());
        while (!queue.isEmpty() && brokenCount < maxToBreak) {
            class_2338 currentPos = (class_2338)queue.poll();
            class_2680 currentState = world.method_8320(currentPos);
            class_2960 currentBlockId = class_7923.field_41175.method_10221((Object)currentState.method_26204());
            if (!this.woodBlockIds.contains(currentBlockId)) continue;
            if (currentPos.method_10264() < lowestY) {
                lowestY = currentPos.method_10264();
                lowestLogPos = currentPos;
            }
            world.method_30093(currentPos, true, (class_1297)player, 1000);
            ++brokenCount;
            if (ModConfig.CONFIG.damagePerBlock && !tool.method_7960() && tool.method_7963()) {
                tool.method_61653(1, player);
            }
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        class_2338 neighborPos = currentPos.method_10069(x, y, z);
                        if (visited.contains(neighborPos)) continue;
                        visited.add(neighborPos);
                        queue.add(neighborPos);
                    }
                }
            }
        }
        if (brokenCount > 0 && ModConfig.CONFIG.replantSaplings) {
            this.plantSapling(world, lowestLogPos, originalLogState, isLargeTree);
        }
    }

    private boolean isLargeTreeStump(class_3218 world, class_2338 startPos, class_2680 logState) {
        class_2338[] positions;
        String blockId = class_7923.field_41175.method_10221((Object)logState.method_26204()).toString();
        if (!(blockId.equals("minecraft:dark_oak_log") || blockId.equals("minecraft:jungle_log") || blockId.equals("minecraft:pale_oak_log"))) {
            return false;
        }
        for (class_2338 pos : positions = new class_2338[]{startPos, startPos.method_10069(1, 0, 0), startPos.method_10069(0, 0, 1), startPos.method_10069(1, 0, 1)}) {
            class_2680 state = world.method_8320(pos);
            if (class_7923.field_41175.method_10221((Object)state.method_26204()).equals((Object)blockId)) continue;
            return false;
        }
        return true;
    }

    private void plantSapling(class_3218 world, class_2338 saplingPos, class_2680 originalLogState, boolean isLargeTree) {
        class_2248 saplingBlock;
        if (world.method_8320(saplingPos).method_26215() && world.method_8320(saplingPos.method_10074()).method_26212((class_1922)world, saplingPos.method_10074()) && (saplingBlock = this.getSaplingForLog(originalLogState)) != null && saplingBlock != class_2246.field_10124) {
            if (isLargeTree || saplingBlock == class_2246.field_10160 || saplingBlock == class_2246.field_10276 || saplingBlock == class_2246.field_54712) {
                this.plant2x2Saplings(world, saplingPos, saplingBlock);
            } else {
                world.method_8501(saplingPos, saplingBlock.method_9564());
            }
        }
    }

    private void plant2x2Saplings(class_3218 world, class_2338 centerPos, class_2248 saplingBlock) {
        class_2338[] positions = new class_2338[]{centerPos, centerPos.method_10069(1, 0, 0), centerPos.method_10069(0, 0, 1), centerPos.method_10069(1, 0, 1)};
        boolean canPlantAll = true;
        for (class_2338 pos : positions) {
            if (world.method_8320(pos).method_26215() && world.method_8320(pos.method_10074()).method_26212((class_1922)world, pos.method_10074())) continue;
            canPlantAll = false;
            break;
        }
        if (canPlantAll) {
            for (class_2338 pos : positions) {
                world.method_8501(pos, saplingBlock.method_9564());
            }
        } else {
            world.method_8501(centerPos, saplingBlock.method_9564());
        }
    }

    private class_2248 getSaplingForLog(class_2680 logState) {
        if (logState.method_26215()) {
            return class_2246.field_10394;
        }
        String blockId = class_7923.field_41175.method_10221((Object)logState.method_26204()).toString();
        if (blockId.equals("minecraft:oak_log") || blockId.equals("minecraft:oak_wood")) {
            return class_2246.field_10394;
        }
        if (blockId.equals("minecraft:birch_log") || blockId.equals("minecraft:birch_wood")) {
            return class_2246.field_10575;
        }
        if (blockId.equals("minecraft:spruce_log") || blockId.equals("minecraft:spruce_wood")) {
            return class_2246.field_10217;
        }
        if (blockId.equals("minecraft:jungle_log") || blockId.equals("minecraft:jungle_wood")) {
            return class_2246.field_10276;
        }
        if (blockId.equals("minecraft:acacia_log") || blockId.equals("minecraft:acacia_wood")) {
            return class_2246.field_10385;
        }
        if (blockId.equals("minecraft:dark_oak_log") || blockId.equals("minecraft:dark_oak_wood")) {
            return class_2246.field_10160;
        }
        if (blockId.equals("minecraft:mangrove_log") || blockId.equals("minecraft:mangrove_wood")) {
            return class_2246.field_37544;
        }
        if (blockId.equals("minecraft:pale_oak_log") || blockId.equals("minecraft:pale_oak_wood")) {
            return class_2246.field_54712;
        }
        if (blockId.equals("minecraft:cherry_log") || blockId.equals("minecraft:cherry_wood")) {
            return class_2246.field_42727;
        }
        if (blockId.equals("minecraft:crimson_stem") || blockId.equals("minecraft:crimson_hyphae")) {
            return class_2246.field_22121;
        }
        if (blockId.equals("minecraft:warped_stem") || blockId.equals("minecraft:warped_hyphae")) {
            return class_2246.field_22114;
        }
        String saplingId = blockId.replace("_log", "_sapling").replace("_wood", "_sapling").replace("_stem", "_sapling").replace("_hyphae", "_sapling");
        try {
            class_2960 saplingIdentifier = class_2960.method_60654((String)saplingId);
            if (class_7923.field_41175.method_10250(saplingIdentifier)) {
                class_2248 foundSapling = (class_2248)class_7923.field_41175.method_63535(saplingIdentifier);
                System.out.println("Found sapling: " + String.valueOf(class_7923.field_41175.method_10221((Object)foundSapling)));
                return foundSapling;
            }
        }
        catch (Exception e) {
            System.out.println("Error finding sapling: " + e.getMessage());
        }
        System.out.println("Using fallback: OAK_SAPLING");
        return class_2246.field_10394;
    }

    private Set<class_2338> getAdjacentPositions(class_2338 center) {
        HashSet<class_2338> positions = new HashSet<class_2338>();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    positions.add(center.method_10069(x, y, z));
                }
            }
        }
        return positions;
    }

    public boolean isAxe(class_1799 stack) {
        class_1792 item = stack.method_7909();
        String id = class_7923.field_41178.method_10221((Object)item).method_12832();
        return id.endsWith("_axe");
    }
}

