/*
 * Decompiled with CFR 0.152.
 */
package de.mschae23.grindenchantments.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.mschae23.grindenchantments.GrindEnchantmentsMod;
import de.mschae23.grindenchantments.config.FilterAction;
import de.mschae23.grindenchantments.impl.MoveOperation;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1887;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9304;
import net.minecraft.class_9636;
import org.apache.logging.log4j.Level;

public record FilterConfig(boolean enabled, ItemConfig item, EnchantmentConfig enchantment, FilterAction curses) {
    public static final Codec<FilterConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("enabled").forGetter(FilterConfig::enabled), (App)ItemConfig.CODEC.fieldOf("item").forGetter(FilterConfig::item), (App)EnchantmentConfig.CODEC.fieldOf("enchantment").forGetter(FilterConfig::enchantment), (App)FilterAction.CODEC.fieldOf("cursed_enchantments").forGetter(FilterConfig::curses)).apply((Applicative)instance, instance.stable(FilterConfig::new)));
    public static final FilterConfig DEFAULT = new FilterConfig(true, ItemConfig.DEFAULT, EnchantmentConfig.DEFAULT, FilterAction.IGNORE);
    public static final FilterConfig DISABLED = new FilterConfig(false, ItemConfig.DEFAULT, EnchantmentConfig.DEFAULT, FilterAction.IGNORE);

    public static class_9139<class_2540, FilterConfig> createPacketCodec() {
        return class_9139.method_56905((class_9139)class_9135.field_48547, FilterConfig::enabled, ItemConfig.createPacketCodec(), FilterConfig::item, EnchantmentConfig.createPacketCodec(), FilterConfig::enchantment, FilterAction.PACKET_CODEC, FilterConfig::curses, FilterConfig::new);
    }

    private boolean shouldDeny(class_9304.class_9305 builder) {
        if (this.curses == FilterAction.DENY) {
            for (class_6880 entry : builder.method_57545()) {
                if (!entry.method_40220(class_9636.field_51551)) continue;
                return true;
            }
        }
        if (this.enchantment.action == FilterAction.DENY) {
            for (class_6880 entry : builder.method_57545()) {
                if (!entry.method_40230().map(key -> this.enchantment.enchantments.contains(key.method_29177())).orElse(false).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public class_9304 filter(class_9304 enchantments) {
        if (!this.enabled) {
            return enchantments;
        }
        class_9304.class_9305 builder = new class_9304.class_9305(enchantments);
        if (this.shouldDeny(builder)) {
            return class_9304.field_49385;
        }
        builder.method_57548(enchantment -> this.curses == FilterAction.IGNORE && enchantment.method_40220(class_9636.field_51551) || this.enchantment.action == FilterAction.IGNORE == enchantment.method_40230().map(key -> this.enchantment.enchantments.contains(key.method_29177())).orElse(false));
        return builder.method_57549();
    }

    public class_9304 filterReversed(class_9304 enchantments, boolean onlyRemoveFirst, class_7225.class_7874 wrapperLookup) {
        if (!this.enabled) {
            return class_9304.field_49385;
        }
        class_9304.class_9305 builder = new class_9304.class_9305(enchantments);
        if (this.shouldDeny(builder)) {
            return class_9304.field_49385;
        }
        class_9304 normalOrderFilteredEnchantments = onlyRemoveFirst ? this.filter(enchantments) : null;
        ObjectIntPair<class_6880<class_1887>> firstEnchantment = onlyRemoveFirst ? MoveOperation.getFirstEnchantment(normalOrderFilteredEnchantments, false, wrapperLookup) : null;
        builder.method_57548(enchantment -> !(this.curses != FilterAction.ALLOW && enchantment.method_40220(class_9636.field_51551) || this.enchantment.action == FilterAction.ALLOW != enchantment.method_40230().map(key -> this.enchantment.enchantments.contains(key.method_29177())).orElse(false) || onlyRemoveFirst && enchantment.method_40230().flatMap(key -> ((class_6880)firstEnchantment.left()).method_40230().map(firstEnchantmentKey -> key.method_29177().equals((Object)firstEnchantmentKey.method_29177()))).orElse(false) == false));
        return builder.method_57549();
    }

    public void validateRegistryEntries(class_7225.class_7874 wrapperLookup) {
        this.item.validateRegistryEntries(wrapperLookup);
        this.enchantment.validateRegistryEntries(wrapperLookup);
    }

    @Override
    public String toString() {
        return "FilterConfig{enabled=" + this.enabled + ", item=" + String.valueOf(this.item) + ", enchantment=" + String.valueOf(this.enchantment) + ", curses=" + String.valueOf((Object)this.curses) + "}";
    }

    public record ItemConfig(List<class_2960> items, FilterAction action) {
        public static final Codec<ItemConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.method_65313((Codec)class_2960.field_25139).fieldOf("enchantments").forGetter(ItemConfig::items), (App)FilterAction.NON_IGNORE_CODEC.fieldOf("action").forGetter(ItemConfig::action)).apply((Applicative)instance, instance.stable(ItemConfig::new)));
        public static final ItemConfig DEFAULT = new ItemConfig(List.of(), FilterAction.DENY);

        public static class_9139<class_2540, ItemConfig> createPacketCodec() {
            return class_9139.method_56435((class_9139)class_2960.field_48267.method_56433(class_9135.method_56363()), ItemConfig::items, FilterAction.PACKET_CODEC, ItemConfig::action, ItemConfig::new);
        }

        public void validateRegistryEntries(class_7225.class_7874 wrapperLookup) {
            Optional registryWrapperOpt = wrapperLookup.method_46759(class_7924.field_41197);
            if (registryWrapperOpt.isEmpty()) {
                GrindEnchantmentsMod.log(Level.WARN, "Item registry is not present");
                return;
            }
            class_7225.class_7226 registryWrapper = (class_7225.class_7226)registryWrapperOpt.get();
            this.items.stream().map(item -> Pair.of((Object)item, (Object)registryWrapper.method_46746(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)item)))).flatMap(result -> ((Optional)result.getSecond()).isEmpty() ? Stream.of((class_2960)result.getFirst()) : Stream.empty()).map(class_2960::toString).forEach(item -> GrindEnchantmentsMod.log(Level.WARN, "Filter config contains unknown item: " + item));
        }

        @Override
        public String toString() {
            return "ItemConfig{items=" + String.valueOf(this.items) + ", action=" + String.valueOf((Object)this.action) + "}";
        }
    }

    public record EnchantmentConfig(List<class_2960> enchantments, FilterAction action) {
        public static final Codec<EnchantmentConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.method_65313((Codec)class_2960.field_25139).fieldOf("enchantments").forGetter(EnchantmentConfig::enchantments), (App)FilterAction.CODEC.fieldOf("action").forGetter(EnchantmentConfig::action)).apply((Applicative)instance, instance.stable(EnchantmentConfig::new)));
        public static final EnchantmentConfig DEFAULT = new EnchantmentConfig(List.of(), FilterAction.IGNORE);

        public static class_9139<class_2540, EnchantmentConfig> createPacketCodec() {
            return class_9139.method_56435((class_9139)class_2960.field_48267.method_56433(class_9135.method_56363()), EnchantmentConfig::enchantments, FilterAction.PACKET_CODEC, EnchantmentConfig::action, EnchantmentConfig::new);
        }

        public void validateRegistryEntries(class_7225.class_7874 wrapperLookup) {
            Optional registryWrapperOpt = wrapperLookup.method_46759(class_7924.field_41265);
            if (registryWrapperOpt.isEmpty()) {
                GrindEnchantmentsMod.log(Level.WARN, "Enchantment registry is not present");
                return;
            }
            class_7225.class_7226 registryWrapper = (class_7225.class_7226)registryWrapperOpt.get();
            this.enchantments.stream().map(enchantment -> Pair.of((Object)enchantment, (Object)registryWrapper.method_46746(class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)enchantment)))).flatMap(result -> ((Optional)result.getSecond()).isEmpty() ? Stream.of((class_2960)result.getFirst()) : Stream.empty()).map(class_2960::toString).forEach(item -> GrindEnchantmentsMod.log(Level.WARN, "Filter config contains unknown enchantment: " + item));
        }

        @Override
        public String toString() {
            return "EnchantmentConfig{enchantments=" + String.valueOf(this.enchantments) + ", action=" + String.valueOf((Object)this.action) + "}";
        }
    }
}

