/*
 * Decompiled with CFR 0.152.
 */
package de.mschae23.grindenchantments.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.mschae23.grindenchantments.GrindEnchantmentsMod;
import de.mschae23.grindenchantments.cost.AverageCountCostFunction;
import de.mschae23.grindenchantments.cost.CostFunction;
import de.mschae23.grindenchantments.cost.CountLevelsCostFunction;
import de.mschae23.grindenchantments.cost.TransformCostFunction;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.apache.logging.log4j.Level;

public record ResetRepairCostConfig(boolean enabled, List<class_2960> catalystItems, boolean requiresEnchantment, CostFunction costFunction) {
    public static final Codec<ResetRepairCostConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("enabled").forGetter(ResetRepairCostConfig::enabled), (App)class_5699.method_65313((Codec)class_2960.field_25139).fieldOf("catalyst_items").forGetter(ResetRepairCostConfig::catalystItems), (App)Codec.BOOL.fieldOf("requires_enchantment").forGetter(ResetRepairCostConfig::requiresEnchantment), (App)CostFunction.CODEC.fieldOf("cost_function").forGetter(ResetRepairCostConfig::costFunction)).apply((Applicative)instance, instance.stable(ResetRepairCostConfig::new)));
    public static final ResetRepairCostConfig DEFAULT = new ResetRepairCostConfig(false, List.of(class_2960.method_60656((String)"diamond")), true, new TransformCostFunction(new AverageCountCostFunction(new CountLevelsCostFunction(1.0, 4.0)), 1.5, 4.0));
    public static final ResetRepairCostConfig DISABLED = new ResetRepairCostConfig(false, List.of(), false, new CountLevelsCostFunction(1.0, 1.0));

    public static class_9139<class_2540, ResetRepairCostConfig> createPacketCodec(class_9139<class_2540, CostFunction> costFunctionCodec) {
        return class_9139.method_56905((class_9139)class_9135.field_48547, ResetRepairCostConfig::enabled, (class_9139)class_2960.field_48267.method_56433(class_9135.method_56363()), ResetRepairCostConfig::catalystItems, (class_9139)class_9135.field_48547, ResetRepairCostConfig::requiresEnchantment, costFunctionCodec, ResetRepairCostConfig::costFunction, ResetRepairCostConfig::new);
    }

    public void validateRegistryEntries(class_7225.class_7874 wrapperLookup) {
        Optional registryWrapperOpt = wrapperLookup.method_46759(class_7924.field_41197);
        if (registryWrapperOpt.isEmpty()) {
            GrindEnchantmentsMod.log(Level.WARN, "Item registry is not present");
            return;
        }
        class_7225.class_7226 registryWrapper = (class_7225.class_7226)registryWrapperOpt.get();
        this.catalystItems.stream().map(item -> Pair.of((Object)item, (Object)registryWrapper.method_46746(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)item)))).flatMap(result -> ((Optional)result.getSecond()).isEmpty() ? Stream.of((class_2960)result.getFirst()) : Stream.empty()).map(class_2960::toString).forEach(item -> GrindEnchantmentsMod.log(Level.WARN, "Reset repair cost config contains unknown catalyst item: " + item));
    }

    @Override
    public String toString() {
        return "ResetRepairCostConfig{enabled=" + this.enabled + ", catalystItems=" + String.valueOf(this.catalystItems) + ", requiresEnchantment=" + this.requiresEnchantment + ", costConfig=" + String.valueOf(this.costFunction) + "}";
    }
}

