/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.windchimes;

import com.moigferdsrte.windchimes.ChimeType;
import com.moigferdsrte.windchimes.Initializer;
import com.moigferdsrte.windchimes.WindchimeBlock;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class WindchimeBlockEntity
extends class_2586 {
    public int ringingTicks = 0;
    public float strengthDivisor = 35.0f;
    protected int ticksToNextRing = 40;
    protected int baselineRingTicks = 0;
    @Nullable
    protected ChimeType cachedType;
    protected boolean cachedTypeNeedsUpdate;
    protected final int tickDisplacement;

    public WindchimeBlockEntity(class_2338 pos, class_2680 state) {
        super(Initializer.CHIME_BLOCK_ENTITY, pos, state);
        this.cachedType = ((WindchimeBlock)state.method_26204()).getChimeType();
        this.cachedTypeNeedsUpdate = true;
        this.tickDisplacement = Math.abs(this.field_11867.method_10263() + this.field_11867.method_10264() + this.field_11867.method_10260()) % 6;
    }

    public void ring(boolean isLoud) {
        assert (this.field_11863 != null);
        if (this.field_11863.method_8320(this.field_11867.method_10074()).method_26215()) {
            this.field_11863.method_8427(this.field_11867, this.field_11863.method_8320(this.field_11867).method_26204(), 1, isLoud ? 1 : 0);
        }
    }

    public boolean method_11004(int type, int data) {
        if (type == 1) {
            if (data == 0) {
                this.ringingTicks = 60;
                this.strengthDivisor = 35.0f;
                assert (this.field_11863 != null);
                this.field_11863.method_8396(null, this.field_11867, this.getChimeType().quietSound, class_3419.field_15247, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f, 0.8f + this.field_11863.field_9229.method_43057() * 0.4f);
            } else {
                this.strengthDivisor = 55.0f;
                this.ringingTicks = 140;
                this.field_11863.method_8396(null, this.field_11867, this.getChimeType().loudSound, class_3419.field_15247, 0.9f + this.field_11863.field_9229.method_43057() * 0.2f, 0.8f + this.field_11863.field_9229.method_43057() * 0.4f);
            }
            return true;
        }
        return super.method_11004(type, data);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, WindchimeBlockEntity that) {
        if (world.field_9236) {
            if (that.ringingTicks > that.baselineRingTicks) {
                --that.ringingTicks;
            }
            if (that.ringingTicks < that.baselineRingTicks) {
                that.ringingTicks = that.baselineRingTicks;
            }
            that.baselineRingTicks = world.method_8419() ? (world.method_8546() ? 26 : 12) : (world.method_8530() ? 0 : 6);
            return;
        }
        --that.ticksToNextRing;
        if (that.ticksToNextRing <= 0 && world.method_8510() % 6L == (long)that.tickDisplacement) {
            if (world.method_8419()) {
                if (world.method_8546()) {
                    that.ticksToNextRing = world.field_9229.method_43048(200);
                    that.ring(world.field_9229.method_43048(4) != 0);
                } else {
                    that.ticksToNextRing = 100 + world.field_9229.method_43048(400);
                    that.ring(world.field_9229.method_43048(3) == 0);
                }
            } else if (world.method_8530()) {
                that.ticksToNextRing = 200 + world.field_9229.method_43048(900);
                that.ring(world.field_9229.method_43048(5) == 0);
            } else {
                that.ticksToNextRing = 100 + world.field_9229.method_43048(700);
                that.ring(world.field_9229.method_43048(5) == 0);
            }
        }
    }

    public ChimeType getChimeType() {
        if (this.cachedTypeNeedsUpdate) {
            this.cachedType = ((WindchimeBlock)this.method_11010().method_26204()).getChimeType();
            this.cachedTypeNeedsUpdate = false;
        }
        return this.cachedType;
    }
}

