/*
 * Decompiled with CFR 0.152.
 */
package com.moigferdsrte.windchimes.refine.dreamcatcher;

import com.moigferdsrte.windchimes.refine.BlockEntityReg;
import com.moigferdsrte.windchimes.refine.BlockReg;
import com.moigferdsrte.windchimes.refine.dreamcatcher.DreamcatcherBlockEntity;
import com.moigferdsrte.windchimes.refine.utils.WoodType;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_7718;
import net.minecraft.class_7923;
import net.minecraft.class_9062;
import net.minecraft.class_9275;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class DreamcatcherBlock
extends class_2237 {
    public static final MapCodec<DreamcatcherBlock> CODEC = DreamcatcherBlock.method_54094(DreamcatcherBlock::new);
    public static final class_2754<class_2350> FACING = class_2383.field_11177;
    public static final class_2746 OFFSET = class_2746.method_11825((String)"offset");
    public static final class_2754<WoodType> WOOD_TYPE = class_2754.method_11850((String)"wood_type", WoodType.class);
    private static final class_265 SHAPE = class_2248.method_9541((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);

    public DreamcatcherBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(WOOD_TYPE, (Comparable)((Object)WoodType.OAK))).method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)OFFSET, (Comparable)Boolean.valueOf(false)));
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (world instanceof class_3218) {
            class_2586 class_25862;
            class_3218 serverWorld = (class_3218)world;
            if (!player.method_7337() && serverWorld.method_8450().method_8355(class_1928.field_19392) && (class_25862 = world.method_8321(pos)) instanceof DreamcatcherBlockEntity) {
                DreamcatcherBlockEntity dreamcatcherBlockEntity = (DreamcatcherBlockEntity)class_25862;
                WoodType woodType = (WoodType)((Object)state.method_11654(WOOD_TYPE));
                class_1799 itemStack = new class_1799((class_1935)this);
                itemStack.method_57365(dreamcatcherBlockEntity.method_57590());
                itemStack.method_57379(class_9334.field_49623, (Object)class_9275.field_49284.method_57420(WOOD_TYPE, (Comparable)((Object)woodType)));
                class_1542 itemEntity = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), itemStack);
                itemEntity.method_6988();
                world.method_8649((class_1297)itemEntity);
            }
        }
        return super.method_9576(world, pos, state, player);
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        class_1799 itemStack = super.method_9574(world, pos, state);
        itemStack.method_57379(class_9334.field_49623, (Object)class_9275.field_49284.method_57420(WOOD_TYPE, (Comparable)((Object)((WoodType)((Object)state.method_11654(WOOD_TYPE))))));
        return itemStack;
    }

    private static boolean calculateOffset(class_1750 ctx) {
        int s = class_7718.method_45479((float)ctx.method_8044());
        return s % 4 != 0;
    }

    private static class_2350 getFacing(class_1750 ctx) {
        class_2350 originalFacing = ctx.method_8042().method_10153();
        int s = class_7718.method_45479((float)ctx.method_8044());
        if (originalFacing == class_2350.field_11034 && s > 0 && s < 4) {
            return class_2350.field_11043;
        }
        if (originalFacing == class_2350.field_11035 && s > 4 && s < 8) {
            return class_2350.field_11034;
        }
        if (originalFacing == class_2350.field_11039 && s > 8 && s < 12) {
            return class_2350.field_11035;
        }
        if (originalFacing == class_2350.field_11043 && s > 12) {
            return class_2350.field_11039;
        }
        return originalFacing;
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)((class_2680)this.method_9564().method_11657(FACING, (Comparable)DreamcatcherBlock.getFacing(ctx))).method_11657((class_2769)OFFSET, (Comparable)Boolean.valueOf(DreamcatcherBlock.calculateOffset(ctx)));
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(FACING)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WOOD_TYPE, OFFSET});
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return DreamcatcherBlock.method_31618(type, BlockEntityReg.DREAM, (class_5558)(world.field_9236 ? DreamcatcherBlockEntity::clientTick : DreamcatcherBlockEntity::serverTick));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return !world.method_22347(pos.method_10084()) && world.method_22347(pos.method_10074()) && this.noSameBlockNearby((class_1922)world, pos);
    }

    public boolean noSameBlockNearby(class_1922 world, class_2338 pos) {
        class_2680 north = world.method_8320(pos.method_10095());
        class_2680 south = world.method_8320(pos.method_10072());
        class_2680 west = world.method_8320(pos.method_10067());
        class_2680 east = world.method_8320(pos.method_10078());
        return !north.method_27852(BlockReg.DREAM) && !south.method_27852(BlockReg.DREAM) && !west.method_27852(BlockReg.DREAM) && !east.method_27852(BlockReg.DREAM);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 newState, class_1936 world, class_2338 pos, class_2338 posFrom) {
        if (world.method_22347(pos.method_10084())) {
            Objects.requireNonNull(world.method_8321(pos)).method_11012();
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, direction, newState, world, pos, posFrom);
    }

    public boolean method_9592(class_2680 state, class_1937 world, class_2338 pos, int type, int data) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof class_2586) {
            class_2586 entity = class_25862;
            return entity.method_11004(type, data);
        }
        return false;
    }

    public static boolean hasBedNearby(class_1937 world, class_2338 pos) {
        for (int i = pos.method_10264() - 2; i <= pos.method_10264() + 2; ++i) {
            for (int j = pos.method_10263() - 3; j <= pos.method_10263() + 3; ++j) {
                for (int k = pos.method_10260() - 3; k <= pos.method_10260() + 3; ++k) {
                    class_2338 targetPos = pos.method_10069(i, j, k);
                    if (!world.method_8320(targetPos).method_26164(class_3481.field_16443)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        DreamcatcherBlockEntity here = (DreamcatcherBlockEntity)world.method_8321(pos);
        assert (here != null);
        here.ring(!player.method_5715());
        here.ticksToNextRing += 4;
        return class_1269.method_29236((boolean)world.field_9236);
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2350 direction = (class_2350)state.method_11654(FACING);
        boolean flag = (Boolean)state.method_11654((class_2769)OFFSET);
        if (class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832().equals("pale_oak_log") && state.method_11654(WOOD_TYPE) != WoodType.PALE_OAK) {
            world.method_8652(pos, (class_2680)((class_2680)((class_2680)state.method_11657(WOOD_TYPE, (Comparable)((Object)WoodType.PALE_OAK))).method_11657(FACING, (Comparable)direction)).method_11657((class_2769)OFFSET, (Comparable)Boolean.valueOf(flag)), 11);
            stack.method_57008(1, (class_1309)player);
            return class_9062.field_47728;
        }
        if (stack.method_31573(class_3489.field_15539) && class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836().equals("minecraft")) {
            world.method_8396(null, pos, class_3417.field_15065, class_3419.field_15245, 1.0f, 1.0f);
            if (stack.method_31574(class_1802.field_8583) && state.method_11654(WOOD_TYPE) != WoodType.OAK) {
                stack.method_57008(1, (class_1309)player);
                world.method_8652(pos, (class_2680)((class_2680)((class_2680)state.method_11657(WOOD_TYPE, (Comparable)((Object)WoodType.OAK))).method_11657(FACING, (Comparable)direction)).method_11657((class_2769)OFFSET, (Comparable)Boolean.valueOf(flag)), 11);
            }
            if (stack.method_31574(class_1802.field_8820) && state.method_11654(WOOD_TYPE) != WoodType.ACACIA) {
                stack.method_57008(1, (class_1309)player);
                world.method_8652(pos, (class_2680)((class_2680)((class_2680)state.method_11657(WOOD_TYPE, (Comparable)((Object)WoodType.ACACIA))).method_11657(FACING, (Comparable)direction)).method_11657((class_2769)OFFSET, (Comparable)Boolean.valueOf(flag)), 11);
            }
            if (stack.method_31574(class_1802.field_8170) && state.method_11654(WOOD_TYPE) != WoodType.BIRCH) {
                stack.method_57008(1, (class_1309)player);
                world.method_8652(pos, (class_2680)((class_2680)((class_2680)state.method_11657(WOOD_TYPE, (Comparable)((Object)WoodType.BIRCH))).method_11657(FACING, (Comparable)direction)).method_11657((class_2769)OFFSET, (Comparable)Boolean.valueOf(flag)), 11);
            }
            if (stack.method_31574(class_1802.field_8652) && state.method_11654(WOOD_TYPE) != WoodType.DARK_OAK) {
                stack.method_57008(1, (class_1309)player);
                world.method_8652(pos, (class_2680)((class_2680)((class_2680)state.method_11657(WOOD_TYPE, (Comparable)((Object)WoodType.DARK_OAK))).method_11657(FACING, (Comparable)direction)).method_11657((class_2769)OFFSET, (Comparable)Boolean.valueOf(flag)), 11);
            }
            if (stack.method_31574(class_1802.field_8125) && state.method_11654(WOOD_TYPE) != WoodType.JUNGLE) {
                stack.method_57008(1, (class_1309)player);
                world.method_8652(pos, (class_2680)((class_2680)((class_2680)state.method_11657(WOOD_TYPE, (Comparable)((Object)WoodType.JUNGLE))).method_11657(FACING, (Comparable)direction)).method_11657((class_2769)OFFSET, (Comparable)Boolean.valueOf(flag)), 11);
            }
            if (stack.method_31574(class_1802.field_8684) && state.method_11654(WOOD_TYPE) != WoodType.SPRUCE) {
                stack.method_57008(1, (class_1309)player);
                world.method_8652(pos, (class_2680)((class_2680)((class_2680)state.method_11657(WOOD_TYPE, (Comparable)((Object)WoodType.SPRUCE))).method_11657(FACING, (Comparable)direction)).method_11657((class_2769)OFFSET, (Comparable)Boolean.valueOf(flag)), 11);
            }
            if (stack.method_31574(class_1802.field_42692) && state.method_11654(WOOD_TYPE) != WoodType.CHERRY) {
                stack.method_57008(1, (class_1309)player);
                world.method_8652(pos, (class_2680)((class_2680)((class_2680)state.method_11657(WOOD_TYPE, (Comparable)((Object)WoodType.CHERRY))).method_11657(FACING, (Comparable)direction)).method_11657((class_2769)OFFSET, (Comparable)Boolean.valueOf(flag)), 11);
            }
            return class_9062.field_47728;
        }
        return super.method_55765(stack, state, world, pos, player, hand, hit);
    }

    protected MapCodec<DreamcatcherBlock> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new DreamcatcherBlockEntity(pos, state);
    }

    public void method_9568(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 options) {
        super.method_9568(stack, context, tooltip, options);
        class_9275 blockStateComponent = (class_9275)stack.method_57825(class_9334.field_49623, (Object)class_9275.field_49284);
        WoodType woodType = Objects.requireNonNullElse((WoodType)((Object)blockStateComponent.method_57418(WOOD_TYPE)), WoodType.OAK);
        if (options.method_47370()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.windchimes.dreamcatcher_type.info").method_27692(class_124.field_1068));
        }
        switch (woodType) {
            case OAK: {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.windchimes.dreamcatcher_type.oak").method_27692(class_124.field_1080));
                break;
            }
            case ACACIA: {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.windchimes.dreamcatcher_type.acacia").method_27692(class_124.field_1080));
                break;
            }
            case BIRCH: {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.windchimes.dreamcatcher_type.birch").method_27692(class_124.field_1080));
                break;
            }
            case DARK_OAK: {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.windchimes.dreamcatcher_type.dark_oak").method_27692(class_124.field_1080));
                break;
            }
            case JUNGLE: {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.windchimes.dreamcatcher_type.jungle").method_27692(class_124.field_1080));
                break;
            }
            case SPRUCE: {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.windchimes.dreamcatcher_type.spruce").method_27692(class_124.field_1080));
                break;
            }
            case CHERRY: {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.windchimes.dreamcatcher_type.cherry").method_27692(class_124.field_1080));
                break;
            }
            case PALE_OAK: {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.windchimes.dreamcatcher_type.pale_oak").method_27692(class_124.field_1080));
                break;
            }
            default: {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.windchimes.dreamcatcher_type.empty").method_27692(class_124.field_1080));
            }
        }
    }
}

