/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.bytechat;

import java.io.File;
import org.bukkit.command.Command;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;
import team.bytephoria.bstats.bukkit.Metrics;
import team.bytephoria.bytechat.commands.ChatCommand;
import team.bytephoria.bytechat.configuration.ChatConfiguration;
import team.bytephoria.bytechat.configuration.FormatConfiguration;
import team.bytephoria.bytechat.listener.AsyncChatListener;
import team.bytephoria.bytechat.loader.ChatFormatLoader;
import team.bytephoria.bytechat.manager.ChatManager;
import team.bytephoria.bytechat.registry.ChatFormatRegistry;
import team.bytephoria.bytechat.serializer.component.ComponentSerializerAdapter;
import team.bytephoria.bytechat.serializer.component.ComponentSerializerFactory;
import team.bytephoria.bytechat.servive.MentionResolverService;

public final class PaperPlugin
extends JavaPlugin {
    private ChatConfiguration chatConfiguration;
    private ComponentSerializerAdapter componentSerializerAdapter;
    private ChatFormatRegistry chatFormatRegistry;
    private ChatManager chatManager;
    private MentionResolverService mentionResolverService;
    private Metrics metrics;

    public void onEnable() {
        this.chatConfiguration = this.loadConfiguration("config", ChatConfiguration.class, true);
        String serializerType = this.chatConfiguration.settings().serializer();
        this.componentSerializerAdapter = ComponentSerializerFactory.create(serializerType);
        this.chatFormatRegistry = new ChatFormatRegistry();
        this.chatManager = new ChatManager(this.chatFormatRegistry, this.chatConfiguration);
        this.mentionResolverService = new MentionResolverService(this.chatConfiguration);
        FormatConfiguration formatConfiguration = this.loadConfiguration("formats", FormatConfiguration.class, true);
        if (formatConfiguration != null) {
            new ChatFormatLoader(this.chatFormatRegistry, formatConfiguration).load();
        }
        if (this.chatConfiguration.chat().enabled()) {
            this.getServer().getPluginManager().registerEvents((Listener)new AsyncChatListener(this), (Plugin)this);
        }
        this.getServer().getCommandMap().register("bytechat", (Command)new ChatCommand(this));
        this.metrics = new Metrics(this, 27686);
    }

    public void onDisable() {
        HandlerList.unregisterAll((Plugin)this);
        this.getServer().getCommandMap().getKnownCommands().remove("bytechat");
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
        if (this.chatFormatRegistry != null) {
            this.chatFormatRegistry.clearAll();
        }
        this.metrics = null;
        this.mentionResolverService = null;
        this.chatManager = null;
        this.chatFormatRegistry = null;
        this.componentSerializerAdapter = null;
        this.chatConfiguration = null;
    }

    public void reload() {
        this.onDisable();
        this.onEnable();
    }

    public MentionResolverService mentionResolverService() {
        return this.mentionResolverService;
    }

    public ChatConfiguration chatConfiguration() {
        return this.chatConfiguration;
    }

    public ComponentSerializerAdapter serializerAdapter() {
        return this.componentSerializerAdapter;
    }

    public ChatManager chatManager() {
        return this.chatManager;
    }

    @NotNull
    private @NotNull AbstractConfigurationLoader<@NotNull CommentedConfigurationNode> createConfiguration(@NotNull String fileName, boolean copyFromResources) {
        File file = this.resolveFile(fileName);
        if (copyFromResources && !file.exists()) {
            this.saveResource(file.getName(), false);
        }
        return ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().indent(2).nodeStyle(NodeStyle.BLOCK).file(file)).build();
    }

    @Nullable
    private <T> T loadConfiguration(@NotNull String fileName, @NotNull Class<T> tClass, boolean copyFromResources) {
        @NotNull AbstractConfigurationLoader<@NotNull CommentedConfigurationNode> yamlConfigurationLoader = this.createConfiguration(fileName, copyFromResources);
        try {
            CommentedConfigurationNode commentedConfigurationNode = (CommentedConfigurationNode)yamlConfigurationLoader.load();
            Object configuration = commentedConfigurationNode.get(tClass);
            commentedConfigurationNode.set(tClass, configuration);
            return (T)configuration;
        }
        catch (ConfigurateException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private File resolveFile(@NotNull String fileName) {
        return new File(this.getDataFolder(), fileName + ".yml");
    }
}

