/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.bytechat.chat.element;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.bytephoria.bytechat.serializer.component.ComponentSerializerAdapter;
import team.bytephoria.bytechat.util.ComponentUtil;

public final class ChatElement {
    @NotNull
    private final String text;
    @Nullable
    private final List<String> hoverLines;
    @Nullable
    private final ClickEvent.Action clickAction;
    @Nullable
    private final String clickValue;

    public ChatElement(@NotNull String text, @Nullable List<String> hoverLines, @Nullable ClickEvent.Action clickAction, @Nullable String clickValue) {
        this.text = text;
        this.hoverLines = hoverLines;
        this.clickAction = clickAction;
        this.clickValue = clickValue;
    }

    @NotNull
    public String text() {
        return this.text;
    }

    @Nullable
    public List<String> hoverLines() {
        return this.hoverLines;
    }

    @Nullable
    public ClickEvent.Action clickAction() {
        return this.clickAction;
    }

    @Nullable
    public String clickValue() {
        return this.clickValue;
    }

    @NotNull
    public Component toComponent(@NotNull ComponentSerializerAdapter adapter, @Nullable Function<String, String> replacements) {
        ClickEvent click;
        String processedText = this.apply(this.text, replacements);
        Component component = adapter.deserialize(processedText);
        HoverEvent<Component> hover = this.createHoverEvent(adapter, replacements);
        if (hover != null) {
            component = component.hoverEvent(hover);
        }
        if ((click = this.createClickEvent(replacements)) != null) {
            component = component.clickEvent(click);
        }
        return component;
    }

    @Nullable
    private HoverEvent<Component> createHoverEvent(@NotNull ComponentSerializerAdapter adapter, @Nullable Function<String, String> replacements) {
        if (this.hoverLines == null || this.hoverLines.isEmpty()) {
            return null;
        }
        ArrayList<Object> lines = new ArrayList<Object>(this.hoverLines.size());
        for (String line : this.hoverLines) {
            if (line == null || line.isEmpty()) {
                lines.add(Component.empty());
                continue;
            }
            String processed = this.apply(line, replacements);
            lines.add(adapter.deserialize(processed));
        }
        return HoverEvent.showText((Component)ComponentUtil.joinLines(lines));
    }

    @Nullable
    private ClickEvent createClickEvent(@Nullable Function<String, String> replacements) {
        if (this.clickAction == null || this.clickValue == null || this.clickValue.isEmpty()) {
            return null;
        }
        String processedValue = this.apply(this.clickValue, replacements);
        return ClickEvent.clickEvent((ClickEvent.Action)this.clickAction, (String)processedValue);
    }

    @NotNull
    private String apply(@NotNull String input, @Nullable Function<String, String> replacements) {
        if (replacements == null) {
            return input;
        }
        String result = replacements.apply(input);
        return result != null ? result : input;
    }
}

