/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.bytechat.servive;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import team.bytephoria.bytechat.configuration.ChatConfiguration;
import team.bytephoria.bytechat.util.StringUtil;

public final class MentionResolverService {
    private final ChatConfiguration configuration;

    public MentionResolverService(@NotNull ChatConfiguration configuration) {
        this.configuration = configuration;
    }

    @NotNull
    public String resolveMentions(@NotNull Player player, @NotNull String message) {
        ChatConfiguration.Mentions mentions = this.configuration.chat().mentions();
        String[] parts = StringUtil.split(message, ' ');
        if (parts == null) {
            return message;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            ChatConfiguration.Sound sound;
            String word = parts[i];
            if (word.charAt(0) != mentions.triggerChar()) {
                stringBuilder.append(word).append(' ');
                continue;
            }
            int wordLength = word.length();
            int minLength = 4;
            int maxLength = 17;
            if (wordLength < 4 || wordLength > 17) {
                this.appendWord(stringBuilder, word, i, parts.length);
                continue;
            }
            String mentionedPlayerName = word.substring(1);
            Player mentionedPlayer = Bukkit.getPlayerExact((String)mentionedPlayerName);
            if (mentionedPlayer == null) {
                this.appendWord(stringBuilder, word, i, parts.length);
                continue;
            }
            if (!mentions.allowSelfMention() && player == mentionedPlayer) {
                this.appendWord(stringBuilder, word, i, parts.length);
                continue;
            }
            String formattedMention = StringUtil.replace(mentions.format(), "{input_name}", mentionedPlayerName, "{player_name}", mentionedPlayer.getName());
            this.appendWord(stringBuilder, formattedMention, i, parts.length);
            if (!mentions.selfMentionSound() && mentionedPlayer == player || (sound = mentions.sound()).key().isBlank()) continue;
            mentionedPlayer.playSound(Sound.sound((Key)Key.key((String)sound.key()), (Sound.Source)Sound.Source.MASTER, (float)sound.volume(), (float)sound.pitch()));
        }
        return stringBuilder.toString();
    }

    private void appendWord(@NotNull StringBuilder stringBuilder, @NotNull String word, int index, int total) {
        stringBuilder.append(word);
        if (index < total - 1) {
            stringBuilder.append(' ');
        }
    }
}

