/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.bytechat.commands;

import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.jetbrains.annotations.NotNull;
import team.bytephoria.bytechat.PaperPlugin;

public final class ChatCommand
extends BukkitCommand {
    private final PaperPlugin paperPlugin;

    public ChatCommand(@NotNull PaperPlugin paperPlugin) {
        super("bytechat", "Main command for ByteChat", "/<command>", Collections.emptyList());
        this.paperPlugin = paperPlugin;
    }

    public boolean execute(@NotNull CommandSender commandSender, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        String subCommand;
        if (!commandSender.hasPermission("bytechat.command")) {
            commandSender.sendMessage((Component)Component.text((String)"You don't have permission to execute this command!", (TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length == 0) {
            commandSender.sendMessage((Component)Component.text((String)"Invalid command usage. Try '/bytechat reload' or '/bytechat mute'.", (TextColor)NamedTextColor.RED));
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                if (!commandSender.hasPermission("bytechat.command.reload")) {
                    commandSender.sendMessage((Component)Component.text((String)"You don't have permission to execute this command!", (TextColor)NamedTextColor.RED));
                    return true;
                }
                this.paperPlugin.reload();
                commandSender.sendMessage((Component)Component.text((String)"ByteChat has been successfully reloaded!", (TextColor)NamedTextColor.GREEN));
                return true;
            }
            case "mute": {
                if (!commandSender.hasPermission("bytechat.command.mute")) {
                    commandSender.sendMessage((Component)Component.text((String)"You don't have permission to execute this command!", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (this.paperPlugin.muteService().isChatMuted()) {
                    this.paperPlugin.muteService().unmuteChatGlobally();
                    commandSender.sendMessage((Component)Component.text((String)"The chat has been unmuted!", (TextColor)NamedTextColor.GREEN));
                } else {
                    this.paperPlugin.muteService().muteChatGlobally();
                    commandSender.sendMessage((Component)Component.text((String)"The chat has been muted globally!", (TextColor)NamedTextColor.GREEN));
                }
                return true;
            }
        }
        commandSender.sendMessage((Component)Component.text((String)"Invalid command usage. Try '/bytechat reload' or '/bytechat mute'.", (TextColor)NamedTextColor.RED));
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull @NotNull String @NotNull [] args) {
        if (args.length == 1) {
            return List.of("reload", "mute");
        }
        return Collections.emptyList();
    }
}

