/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.bytechat.configuration;

import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Setting;

@ConfigSerializable
public final class ChatConfiguration {
    @Setting(value="settings")
    private Settings settings = new Settings();
    @Setting(value="chat")
    private Chat chat = new Chat();

    public Settings settings() {
        return this.settings;
    }

    public Chat chat() {
        return this.chat;
    }

    @ConfigSerializable
    public static final class Settings {
        @Setting(value="serializer")
        private String serializer = "MINI_MESSAGE";

        public String serializer() {
            return this.serializer;
        }
    }

    @ConfigSerializable
    public static final class Chat {
        @Setting(value="enabled")
        private boolean enabled = true;
        @Setting(value="default-format")
        private String defaultFormat = "default";
        @Setting(value="text-formatting")
        private boolean textFormatting = true;
        @Setting(value="mentions")
        private Mentions mentions = new Mentions();
        @Setting(value="tags")
        private Tags tags = new Tags();

        public boolean enabled() {
            return this.enabled;
        }

        public String defaultFormat() {
            return this.defaultFormat;
        }

        public boolean textFormatting() {
            return this.textFormatting;
        }

        public Mentions mentions() {
            return this.mentions;
        }

        public Tags tags() {
            return this.tags;
        }
    }

    @ConfigSerializable
    public static final class Sound {
        @Setting(value="key")
        private String key = "entity.player.levelup";
        @Setting(value="volume")
        private float volume = 1.0f;
        @Setting(value="pitch")
        private float pitch = 1.0f;

        public String key() {
            return this.key;
        }

        public float volume() {
            return this.volume;
        }

        public float pitch() {
            return this.pitch;
        }
    }

    @ConfigSerializable
    public static final class Tags {
        @Setting(value="enabled")
        private boolean enabled = true;
        @Setting(value="max-tags-per-message")
        private int maxTagsPerMessage = 1;
        @Setting(value="item")
        private ItemTag item = new ItemTag();
        @Setting(value="inventory")
        private InventoryTag inventory = new InventoryTag();
        @Setting(value="armor")
        private ArmorTag armor = new ArmorTag();

        public boolean enabled() {
            return this.enabled;
        }

        public int maxTagsPerMessage() {
            return this.maxTagsPerMessage;
        }

        public ItemTag item() {
            return this.item;
        }

        public InventoryTag inventory() {
            return this.inventory;
        }

        public ArmorTag armor() {
            return this.armor;
        }

        @ConfigSerializable
        public static final class ItemTag {
            @Setting(value="enabled")
            private boolean enabled = true;
            @Setting(value="empty-hand-text")
            private String emptyHandText = "[Empty Hand]";
            @Setting(value="empty-hand-color")
            private String emptyHandColor = "GRAY";

            public boolean enabled() {
                return this.enabled;
            }

            public String emptyHandText() {
                return this.emptyHandText;
            }

            public String emptyHandColor() {
                return this.emptyHandColor;
            }
        }

        @ConfigSerializable
        public static final class InventoryTag {
            @Setting(value="enabled")
            private boolean enabled = true;
            @Setting(value="display-text")
            private String displayText = "[Inventory]";
            @Setting(value="display-color")
            private String displayColor = "AQUA";
            @Setting(value="preview-title")
            private String previewTitle = "Inventory of {player_name}";
            @Setting(value="max-clicks")
            private int maxClicks = 10;
            @Setting(value="expiration-seconds")
            private int expirationSeconds = 70;

            public boolean enabled() {
                return this.enabled;
            }

            public String displayText() {
                return this.displayText;
            }

            public String displayColor() {
                return this.displayColor;
            }

            public String previewTitle() {
                return this.previewTitle;
            }

            public int maxClicks() {
                return this.maxClicks;
            }

            public int expirationSeconds() {
                return this.expirationSeconds;
            }
        }

        @ConfigSerializable
        public static final class ArmorTag {
            @Setting(value="enabled")
            private boolean enabled = true;
            @Setting(value="display-text")
            private String displayText = "[Armor Inventory]";
            @Setting(value="display-color")
            private String displayColor = "AQUA";
            @Setting(value="preview-title")
            private String previewTitle = "Armor of {player_name}";
            @Setting(value="max-clicks")
            private int maxClicks = 10;
            @Setting(value="expiration-seconds")
            private int expirationSeconds = 3600;

            public boolean enabled() {
                return this.enabled;
            }

            public String displayText() {
                return this.displayText;
            }

            public String displayColor() {
                return this.displayColor;
            }

            public String previewTitle() {
                return this.previewTitle;
            }

            public int maxClicks() {
                return this.maxClicks;
            }

            public int expirationSeconds() {
                return this.expirationSeconds;
            }
        }
    }

    @ConfigSerializable
    public static final class Mentions {
        @Setting(value="enabled")
        private boolean enabled = true;
        @Setting(value="trigger-char")
        private char triggerChar = (char)64;
        @Setting(value="format")
        private String format = "<yellow>{tag}</yellow>";
        @Setting(value="allow-self-mention")
        private boolean allowSelfMention = true;
        @Setting(value="self-mention-sound")
        private boolean selfMentionSound = true;
        @Setting(value="sound")
        private Sound sound = new Sound();

        public boolean enabled() {
            return this.enabled;
        }

        public char triggerChar() {
            return this.triggerChar;
        }

        public String format() {
            return this.format;
        }

        public boolean allowSelfMention() {
            return this.allowSelfMention;
        }

        public boolean selfMentionSound() {
            return this.selfMentionSound;
        }

        public Sound sound() {
            return this.sound;
        }
    }
}

