/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.bytechat.loader;

import java.util.LinkedHashMap;
import java.util.List;
import net.kyori.adventure.text.event.ClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.bytephoria.bytechat.api.Loader;
import team.bytephoria.bytechat.chat.element.ChatElement;
import team.bytephoria.bytechat.chat.format.ChatFormat;
import team.bytephoria.bytechat.configuration.FormatConfiguration;
import team.bytephoria.bytechat.registry.ChatFormatRegistry;

public final class ChatFormatLoader
implements Loader {
    private final ChatFormatRegistry registry;
    private final FormatConfiguration configuration;

    public ChatFormatLoader(@NotNull ChatFormatRegistry registry, @NotNull FormatConfiguration configuration) {
        this.registry = registry;
        this.configuration = configuration;
    }

    @Override
    public void load() {
        this.configuration.formats().forEach(this::loadFormat);
    }

    private void loadFormat(@NotNull String id, @NotNull FormatConfiguration.ChatFormat chatFormatConfiguration) {
        LinkedHashMap<String, ChatElement> elements = new LinkedHashMap<String, ChatElement>(chatFormatConfiguration.elements().size());
        chatFormatConfiguration.elements().forEach((elementId, elementConfig) -> {
            ChatElement element = this.createElement((FormatConfiguration.ChatElement)elementConfig);
            elements.put((String)elementId, element);
        });
        ChatFormat chatFormat = new ChatFormat(id, chatFormatConfiguration.permission(), chatFormatConfiguration.priority(), elements);
        this.registry.register(id, chatFormat);
    }

    @NotNull
    private ChatElement createElement(@NotNull FormatConfiguration.ChatElement chatElement) {
        List<String> hoverLines = chatElement.hover();
        FormatConfiguration.ClickAction clickConfig = chatElement.click();
        ClickEvent.Action action = this.parseClickAction(clickConfig.action());
        String value = clickConfig.value();
        return new ChatElement(chatElement.text(), hoverLines, action, value);
    }

    @Nullable
    private ClickEvent.Action parseClickAction(@NotNull String actionName) {
        try {
            return ClickEvent.Action.valueOf((String)actionName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public void unload() {
        this.registry.clearAll();
    }
}

