/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.bytechat.manager;

import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.bytephoria.bytechat.api.Prioritizable;
import team.bytephoria.bytechat.chat.format.ChatFormat;
import team.bytephoria.bytechat.configuration.ChatConfiguration;
import team.bytephoria.bytechat.registry.ChatFormatRegistry;

public final class ChatManager {
    private static final Comparator<ChatFormat> PRIORITY_COMPARATOR = Comparator.comparingInt(Prioritizable::priority);
    private final ChatFormatRegistry chatFormatRegistry;
    private final ChatConfiguration chatConfiguration;

    public ChatManager(@NotNull ChatFormatRegistry chatFormatRegistry, @NotNull ChatConfiguration chatConfiguration) {
        this.chatFormatRegistry = chatFormatRegistry;
        this.chatConfiguration = chatConfiguration;
    }

    @NotNull
    public Optional<ChatFormat> defaultChatFormat() {
        String defaultFormatId = this.chatConfiguration.chat().defaultFormat();
        return Optional.ofNullable((ChatFormat)this.chatFormatRegistry.get(defaultFormatId));
    }

    @Nullable
    public ChatFormat search(@NotNull Permissible permissible) {
        if (this.chatFormatRegistry.size() == 1) {
            ChatFormat singleFormat = (ChatFormat)this.chatFormatRegistry.all().values().iterator().next();
            String permission = singleFormat.permission();
            if (permission == null || permission.isEmpty() || permissible.hasPermission(permission)) {
                return singleFormat;
            }
            String defaultFormatId = this.chatConfiguration.chat().defaultFormat();
            return defaultFormatId.equalsIgnoreCase(singleFormat.id()) ? singleFormat : null;
        }
        return this.resolveBestFor(permissible).or(this::defaultChatFormat).orElse(null);
    }

    @NotNull
    public Stream<ChatFormat> matchingFormats(@NotNull Permissible permissible) {
        return this.chatFormatRegistry.all().values().stream().filter(format -> {
            String permission = format.permission();
            return permission == null || permission.isEmpty() || permissible.hasPermission(permission);
        });
    }

    @NotNull
    public Optional<ChatFormat> highestPriority(@NotNull Stream<ChatFormat> formats) {
        return formats.max(PRIORITY_COMPARATOR);
    }

    @NotNull
    public Optional<ChatFormat> resolveBestFor(@NotNull Permissible permissible) {
        return this.highestPriority(this.matchingFormats(permissible));
    }
}

