/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.bytechat.serializer.component;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import team.bytephoria.bytechat.serializer.component.ComponentSerializerAdapter;
import team.bytephoria.bytechat.serializer.component.LegacyAmpersandComponentSerializerAdapter;
import team.bytephoria.bytechat.serializer.component.MiniMessageComponentSerializerAdapter;
import team.bytephoria.bytechat.serializer.component.PlainComponentSerializerAdapter;
import team.bytephoria.bytechat.util.exception.NonInstantiableClassException;

public final class ComponentSerializerFactory {
    private ComponentSerializerFactory() {
        throw new NonInstantiableClassException();
    }

    @NotNull
    public static ComponentSerializerAdapter create(@NotNull String format) {
        return switch (format.trim().toUpperCase(Locale.ROOT)) {
            case "LEGACY_AMPERSAND" -> new LegacyAmpersandComponentSerializerAdapter();
            case "MINI_MESSAGE" -> new MiniMessageComponentSerializerAdapter();
            default -> new PlainComponentSerializerAdapter();
        };
    }
}

