/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.bytechat.service;

import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.bytephoria.bytechat.configuration.ChatConfiguration;
import team.bytephoria.bytechat.ui.CompleteInventoryPreviewMenu;
import team.bytephoria.bytechat.ui.EquipmentPreviewMenu;
import team.bytephoria.bytechat.util.StringUtil;

public final class TagResolverService {
    private static final char OPEN_BRACKET = '[';
    private static final char CLOSE_BRACKET = ']';
    private static final String PLACEHOLDER_PREFIX = "<<<BYTECHAT_TAG_";
    private static final String PLACEHOLDER_SUFFIX = ">>>";
    private final ChatConfiguration configuration;

    public TagResolverService(@NotNull ChatConfiguration configuration) {
        this.configuration = configuration;
    }

    @NotNull
    public TagResolutionResult resolveTags(@NotNull Player player, @NotNull String message) {
        int maxTags = this.configuration.chat().tags().maxTagsPerMessage();
        ArrayList<TagComponent> tagComponents = new ArrayList<TagComponent>();
        StringBuilder processedMessage = new StringBuilder();
        int tagCounter = 0;
        int index = 0;
        int length = message.length();
        while (index < length) {
            String tagContent;
            Component tagComponent;
            int tagStart;
            int tagEnd;
            if (tagCounter >= maxTags) {
                processedMessage.append(message.substring(index));
                break;
            }
            char c = message.charAt(index);
            if (c == '[' && (tagEnd = message.indexOf(93, tagStart = index)) != -1 && (tagComponent = this.createTagComponent(player, tagContent = message.substring(tagStart + 1, tagEnd))) != null) {
                String placeholder = PLACEHOLDER_PREFIX + tagCounter + PLACEHOLDER_SUFFIX;
                processedMessage.append(placeholder);
                tagComponents.add(new TagComponent(placeholder, tagComponent));
                ++tagCounter;
                index = tagEnd + 1;
                continue;
            }
            processedMessage.append(c);
            ++index;
        }
        return new TagResolutionResult(processedMessage.toString(), tagComponents);
    }

    @Nullable
    private Component createTagComponent(@NotNull Player player, @NotNull String tagType) {
        return switch (tagType.toLowerCase()) {
            case "item" -> this.createItemComponent(player);
            case "inv" -> this.createInventoryComponent(player);
            case "armor" -> this.createEquipmentComponent(player);
            default -> null;
        };
    }

    @Nullable
    private Component createItemComponent(@NotNull Player player) {
        ChatConfiguration.Tags.ItemTag itemConfig = this.configuration.chat().tags().item();
        if (!itemConfig.enabled() && !player.hasPermission("bytechat.format.tag.item")) {
            return null;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType().isAir()) {
            NamedTextColor color = this.parseColor(itemConfig.emptyHandColor());
            return Component.text((String)itemConfig.emptyHandText(), (TextColor)color);
        }
        return item.displayName().hoverEvent((HoverEventSource)HoverEvent.showItem((HoverEvent.ShowItem)((HoverEvent.ShowItem)item.asHoverEvent().value())));
    }

    @Nullable
    private Component createEquipmentComponent(@NotNull Player player) {
        ChatConfiguration.Tags.ArmorTag armorConfig = this.configuration.chat().tags().armor();
        if (!armorConfig.enabled() || !player.hasPermission("bytechat.format.tag.armor")) {
            return null;
        }
        String armorTitle = StringUtil.replaceSingle(this.configuration.chat().tags().armor().previewTitle(), "{player_name}", player.getName());
        EquipmentPreviewMenu previewMenu = EquipmentPreviewMenu.create(player, armorTitle);
        NamedTextColor color = this.parseColor(armorConfig.displayColor());
        return Component.text((String)armorConfig.displayText(), (TextColor)color).clickEvent(ClickEvent.callback(audience -> {
            if (audience instanceof Player) {
                Player clickedPlayer = (Player)audience;
                clickedPlayer.openInventory(previewMenu.getInventory());
            }
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(armorConfig.maxClicks()).lifetime((TemporalAmount)Duration.ofSeconds(armorConfig.expirationSeconds())).build())));
    }

    @Nullable
    private Component createInventoryComponent(@NotNull Player player) {
        ChatConfiguration.Tags.InventoryTag invConfig = this.configuration.chat().tags().inventory();
        if (!invConfig.enabled() || !player.hasPermission("bytechat.format.tag.inventory")) {
            return null;
        }
        String inventoryTitle = StringUtil.replaceSingle(this.configuration.chat().tags().inventory().previewTitle(), "{player_name}", player.getName());
        CompleteInventoryPreviewMenu previewMenu = CompleteInventoryPreviewMenu.create(player, inventoryTitle);
        NamedTextColor color = this.parseColor(invConfig.displayColor());
        return Component.text((String)invConfig.displayText(), (TextColor)color).clickEvent(ClickEvent.callback(audience -> {
            if (audience instanceof Player) {
                Player clickedPlayer = (Player)audience;
                clickedPlayer.openInventory(previewMenu.getInventory());
            }
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(invConfig.maxClicks()).lifetime((TemporalAmount)Duration.ofSeconds(invConfig.expirationSeconds())).build())));
    }

    @NotNull
    private NamedTextColor parseColor(@NotNull String colorName) {
        return (NamedTextColor)NamedTextColor.NAMES.valueOr((Object)colorName.toLowerCase(), (Object)NamedTextColor.WHITE);
    }

    public record TagComponent(@NotNull String placeholder, @NotNull Component component) {
    }

    public record TagResolutionResult(@NotNull String processedMessage, @NotNull List<TagComponent> tagComponents) {
    }
}

