/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.bytechat.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.bytephoria.bytechat.util.exception.NonInstantiableClassException;

public final class StringUtil {
    private StringUtil() {
        throw new NonInstantiableClassException();
    }

    public static @NotNull String @Nullable [] split(@NotNull String message, char splitChar) {
        int length = message.length();
        if (length == 0) {
            return null;
        }
        int parts = 0;
        for (int index = 0; index < length; ++index) {
            char character = message.charAt(index);
            if (character != splitChar) continue;
            ++parts;
        }
        String[] sections = new String[parts + 1];
        int sectionIndex = 0;
        int startIndex = 0;
        for (int index = 0; index < length; ++index) {
            char character = message.charAt(index);
            if (character != splitChar) continue;
            sections[sectionIndex] = message.substring(startIndex, index);
            ++sectionIndex;
            startIndex = index + 1;
        }
        sections[sectionIndex] = message.substring(startIndex);
        return sections;
    }

    @NotNull
    public static String replace(@NotNull String input, String ... replacements) {
        if (replacements.length == 0) {
            return input;
        }
        if ((replacements.length & 1) != 0) {
            throw new IllegalArgumentException("Replacements must be provided in pairs: placeholder, value");
        }
        String result = input;
        for (int i = 0; i < replacements.length; i += 2) {
            String placeholder = replacements[i];
            String value = replacements[i + 1];
            result = StringUtil.replaceSingle(result, placeholder, value);
        }
        return result;
    }

    @NotNull
    public static String replaceSingle(@NotNull String input, @NotNull String placeholder, @NotNull String replacement) {
        int index;
        int placeholderLength = placeholder.length();
        if (placeholderLength == 0 || input.isEmpty()) {
            return input;
        }
        StringBuilder stringBuilder = new StringBuilder(input.length());
        int start = 0;
        while ((index = input.indexOf(placeholder, start)) != -1) {
            stringBuilder.append(input, start, index).append(replacement);
            start = index + placeholderLength;
        }
        if (start < input.length()) {
            stringBuilder.append(input, start, input.length());
        }
        return stringBuilder.toString();
    }
}

