/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.bytechat.chat.renderer;

import io.papermc.paper.chat.ChatRenderer;
import java.util.Collection;
import java.util.function.Function;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import team.bytephoria.bytechat.chat.element.ChatElement;
import team.bytephoria.bytechat.chat.format.ChatFormat;
import team.bytephoria.bytechat.configuration.ChatConfiguration;
import team.bytephoria.bytechat.placeholder.PlaceholderResolver;
import team.bytephoria.bytechat.serializer.component.ComponentSerializerAdapter;

public final class ViewerUnawareChatRenderer
implements ChatRenderer.ViewerUnaware {
    private final ChatFormat chatFormat;
    private final SignedMessage signedMessage;
    private final ChatConfiguration chatConfiguration;
    private final ComponentSerializerAdapter componentSerializerAdapter;

    public ViewerUnawareChatRenderer(@NotNull ChatFormat chatFormat, @NotNull SignedMessage signedMessage, @NotNull ChatConfiguration chatConfiguration, @NotNull ComponentSerializerAdapter componentSerializerAdapter) {
        this.chatFormat = chatFormat;
        this.signedMessage = signedMessage;
        this.chatConfiguration = chatConfiguration;
        this.componentSerializerAdapter = componentSerializerAdapter;
    }

    @NotNull
    public Component render(@NotNull Player source, @NotNull Component sourceDisplayName, @NotNull Component message) {
        String preparedMessage = this.preparePlayerMessage(source);
        Function<String, String> replacements = PlaceholderResolver.create(source, preparedMessage);
        Collection<ChatElement> chatElements = this.chatFormat.allElements();
        return this.composeMessage(chatElements, replacements);
    }

    @NotNull
    private String preparePlayerMessage(@NotNull Player player) {
        boolean allowFormatting = this.chatConfiguration.chat().textFormatting();
        String rawMessage = this.signedMessage.message();
        if (!allowFormatting || !player.hasPermission("bytechat.format.color")) {
            return PlainTextComponentSerializer.plainText().serialize(this.componentSerializerAdapter.getSerializer().deserialize((Object)rawMessage));
        }
        return rawMessage;
    }

    @NotNull
    private Component composeMessage(@NotNull Collection<ChatElement> chatElements, @NotNull Function<String, String> replacements) {
        TextComponent result = Component.empty();
        for (ChatElement element : chatElements) {
            result = result.append(element.toComponent(this.componentSerializerAdapter, replacements));
        }
        return result;
    }
}

