/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.bytechat.serializer.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import team.bytephoria.bytechat.api.Provider;
import team.bytephoria.bytechat.serializer.component.ComponentSerializerAdapter;
import team.bytephoria.bytechat.serializer.component.LegacyAmpersandComponentSerializerAdapter;
import team.bytephoria.bytechat.serializer.component.MiniMessageComponentSerializerAdapter;

public final class ComponentSerializerProvider
implements Provider<ComponentSerializerAdapter> {
    private static final Map<String, Supplier<ComponentSerializerAdapter>> ENGINES = new HashMap<String, Supplier<ComponentSerializerAdapter>>();
    private final ComponentSerializerAdapter adapter;

    public static void register(@NotNull String name, @NotNull Supplier<ComponentSerializerAdapter> engineSupplier) {
        ENGINES.put(name.toUpperCase(), engineSupplier);
    }

    public ComponentSerializerProvider(@NotNull String engineName) {
        String key = engineName.toUpperCase();
        Supplier supplier = Optional.ofNullable(ENGINES.get(key)).orElseGet(() -> LegacyAmpersandComponentSerializerAdapter::new);
        this.adapter = (ComponentSerializerAdapter)supplier.get();
    }

    @Override
    @NotNull
    public ComponentSerializerAdapter get() {
        return this.adapter;
    }

    @NotNull
    public static @UnmodifiableView Set<String> availableEngines() {
        return Collections.unmodifiableSet(ENGINES.keySet());
    }

    static {
        ComponentSerializerProvider.register("MINI_MESSAGE", MiniMessageComponentSerializerAdapter::new);
        ComponentSerializerProvider.register("LEGACY_AMPERSAND", LegacyAmpersandComponentSerializerAdapter::new);
    }
}

