/*
 * Decompiled with CFR 0.152.
 */
package team.bytephoria.bytechat.chat.renderer;

import io.papermc.paper.chat.ChatRenderer;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collection;
import java.util.function.Function;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.bytephoria.bytechat.chat.element.ChatElement;
import team.bytephoria.bytechat.chat.format.ChatFormat;
import team.bytephoria.bytechat.configuration.ChatConfiguration;
import team.bytephoria.bytechat.placeholder.PlaceholderResolver;
import team.bytephoria.bytechat.serializer.component.ComponentSerializerAdapter;
import team.bytephoria.bytechat.service.MentionResolverService;
import team.bytephoria.bytechat.service.TagResolverService;

public final class ViewerUnawareChatRenderer
implements ChatRenderer.ViewerUnaware {
    private final ChatFormat chatFormat;
    private final SignedMessage signedMessage;
    private final ChatConfiguration chatConfiguration;
    private final MentionResolverService mentionResolverService;
    private final TagResolverService tagResolverService;
    private final ComponentSerializerAdapter componentSerializerAdapter;

    public ViewerUnawareChatRenderer(@NotNull ChatFormat chatFormat, @NotNull SignedMessage signedMessage, @NotNull ChatConfiguration chatConfiguration, @NotNull MentionResolverService mentionResolverService, @NotNull TagResolverService tagResolverService, @NotNull ComponentSerializerAdapter componentSerializerAdapter) {
        this.chatFormat = chatFormat;
        this.signedMessage = signedMessage;
        this.chatConfiguration = chatConfiguration;
        this.mentionResolverService = mentionResolverService;
        this.tagResolverService = tagResolverService;
        this.componentSerializerAdapter = componentSerializerAdapter;
    }

    @NotNull
    public Component render(@NotNull Player source, @NotNull Component sourceDisplayName, @NotNull Component message) {
        @NotNull Pair<String, TagResolverService.TagResolutionResult> preparedMessage = this.preparePlayerMessage(source);
        String preparedPlayerMessage = (String)preparedMessage.left();
        TagResolverService.TagResolutionResult tagResolutionResult = (TagResolverService.TagResolutionResult)preparedMessage.right();
        Function<String, String> replacements = PlaceholderResolver.create(source, preparedPlayerMessage);
        Collection<ChatElement> chatElements = this.chatFormat.allElements();
        return this.composeMessage(chatElements, tagResolutionResult, replacements);
    }

    @NotNull
    private Pair<String, TagResolverService.TagResolutionResult> preparePlayerMessage(@NotNull Player player) {
        String resolvedMessage = this.signedMessage.message();
        TagResolverService.TagResolutionResult tagResult = null;
        if (this.chatConfiguration.chat().tags().enabled() && player.hasPermission("bytechat.format.tag.*")) {
            tagResult = this.tagResolverService.resolveTags(player, resolvedMessage);
            resolvedMessage = tagResult.processedMessage();
        }
        if (!this.chatConfiguration.chat().textFormatting() || !player.hasPermission("bytechat.format.color")) {
            resolvedMessage = PlainTextComponentSerializer.plainText().serialize(this.componentSerializerAdapter.deserialize(resolvedMessage));
        }
        if (this.chatConfiguration.chat().mentions().enabled() && player.hasPermission("bytechat.format.mention")) {
            resolvedMessage = this.mentionResolverService.resolveMentions(player, resolvedMessage);
        }
        return Pair.of((Object)resolvedMessage, (Object)tagResult);
    }

    @NotNull
    private Component composeMessage(@NotNull Collection<ChatElement> chatElements, @Nullable TagResolverService.TagResolutionResult tagResolutionResult, @NotNull Function<String, String> replacements) {
        TextComponent result = Component.empty();
        for (ChatElement element : chatElements) {
            result = result.append(element.toComponent(this.componentSerializerAdapter, replacements));
        }
        if (tagResolutionResult != null && !tagResolutionResult.tagComponents().isEmpty()) {
            result = this.injectTagComponents((Component)result, tagResolutionResult);
        }
        return result;
    }

    @NotNull
    private Component injectTagComponents(@NotNull Component message, @NotNull TagResolverService.TagResolutionResult tagResolutionResult) {
        Component result = message;
        for (TagResolverService.TagComponent tagComponent : tagResolutionResult.tagComponents()) {
            String placeholder = tagComponent.placeholder();
            Component component = tagComponent.component();
            result = result.replaceText(builder -> builder.once().matchLiteral(placeholder).replacement((ComponentLike)component));
        }
        return result;
    }
}

