/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultoptions.forge;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Collections;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmRuntimeLoadContext;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.module.BalmModule;
import net.blay09.mods.balm.forge.ForgeLoadContext;
import net.blay09.mods.defaultoptions.DefaultOptions;
import net.blay09.mods.defaultoptions.PlatformBindings;
import net.blay09.mods.defaultoptions.forge.mixin.ForgeKeyMappingAccessor;
import net.blay09.mods.defaultoptions.keys.KeyModifier;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="defaultoptions")
public class ForgeDefaultOptions {
    public ForgeDefaultOptions(FMLJavaModLoadingContext context) {
        ForgeLoadContext loadContext = new ForgeLoadContext(context.getModBusGroup());
        PlatformBindings.INSTANCE = new PlatformBindings(this){

            @Override
            public void setDefaultKeyModifiers(KeyMapping keyMapping, Set<KeyModifier> keyModifiers) {
                KeyModifier keyModifier = keyModifiers.stream().findFirst().orElse(KeyModifier.NONE);
                net.minecraftforge.client.settings.KeyModifier forgeKeyModifier = switch (keyModifier) {
                    case KeyModifier.ALT -> net.minecraftforge.client.settings.KeyModifier.ALT;
                    case KeyModifier.SHIFT -> net.minecraftforge.client.settings.KeyModifier.SHIFT;
                    case KeyModifier.CONTROL -> net.minecraftforge.client.settings.KeyModifier.CONTROL;
                    default -> net.minecraftforge.client.settings.KeyModifier.NONE;
                };
                ((ForgeKeyMappingAccessor)keyMapping).setKeyModifierDefault(forgeKeyModifier);
            }

            @Override
            public void setKeyModifiers(KeyMapping keyMapping, Set<KeyModifier> keyModifiers) {
                KeyModifier keyModifier = keyModifiers.stream().findFirst().orElse(KeyModifier.NONE);
                keyMapping.setKeyModifierAndCode(1.toForge(keyModifier), keyMapping.getKey());
            }

            @Override
            public InputConstants.Key getKey(KeyMapping keyMapping) {
                return keyMapping.getKey();
            }

            @Override
            public Set<KeyModifier> getKeyModifiers(KeyMapping keyMapping) {
                KeyModifier keyModifier = 1.fromForge(keyMapping.getKeyModifier());
                return keyModifier != KeyModifier.NONE ? Set.of(keyModifier) : Collections.emptySet();
            }

            @Override
            public Set<KeyModifier> getDefaultKeyModifiers(KeyMapping keyMapping) {
                KeyModifier keyModifier = 1.fromForge(keyMapping.getDefaultKeyModifier());
                return keyModifier != KeyModifier.NONE ? Set.of(keyModifier) : Collections.emptySet();
            }

            private static KeyModifier fromForge(net.minecraftforge.client.settings.KeyModifier keyModifier) {
                return switch (keyModifier) {
                    default -> throw new MatchException(null, null);
                    case net.minecraftforge.client.settings.KeyModifier.NONE -> KeyModifier.NONE;
                    case net.minecraftforge.client.settings.KeyModifier.SHIFT -> KeyModifier.SHIFT;
                    case net.minecraftforge.client.settings.KeyModifier.CONTROL -> KeyModifier.CONTROL;
                    case net.minecraftforge.client.settings.KeyModifier.ALT -> KeyModifier.ALT;
                };
            }

            private static net.minecraftforge.client.settings.KeyModifier toForge(KeyModifier keyModifier) {
                return switch (keyModifier) {
                    default -> throw new MatchException(null, null);
                    case KeyModifier.NONE -> net.minecraftforge.client.settings.KeyModifier.NONE;
                    case KeyModifier.SHIFT -> net.minecraftforge.client.settings.KeyModifier.SHIFT;
                    case KeyModifier.CONTROL -> net.minecraftforge.client.settings.KeyModifier.CONTROL;
                    case KeyModifier.ALT -> net.minecraftforge.client.settings.KeyModifier.ALT;
                };
            }
        };
        if (FMLEnvironment.dist.isClient()) {
            Balm.initializeMod((String)"defaultoptions", (BalmRuntimeLoadContext)loadContext, (BalmModule[])new BalmModule[0]);
            BalmClient.initializeMod((String)"defaultoptions", (BalmRuntimeLoadContext)loadContext, DefaultOptions::initialize);
        }
        context.registerDisplayTest(IExtensionPoint.DisplayTest.IGNORE_ALL_VERSION);
    }
}

