/*
 * Decompiled with CFR 0.152.
 */
package xiaojin.itemoverlaystate.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ComponentRenderUtils;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TextComponentTagVisitor;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import xiaojin.itemoverlaystate.IosMain;
import xiaojin.itemoverlaystate.client.gui.widget.TextImageButton;
import xiaojin.itemoverlaystate.util.ModNbtUtil;

@OnlyIn(value=Dist.CLIENT)
public class ItemInformationScreen
extends Screen {
    public static final Component TITLE = Component.translatable((String)"itemoverlaystate.item_information_screen");
    private static final ResourceLocation BG_TEXTURE = IosMain.modRL("textures/gui/container/item_information_screen.png");
    private static final ResourceLocation PAGINATION_DEFAULT_TEXT = IosMain.modRL("item_information/pagination/default");
    private static final ResourceLocation PAGINATION_DEFAULT_PRESS_TEXT = IosMain.modRL("item_information/pagination/default_press");
    private static final ResourceLocation PAGINATION_FLOAT_TEXT = IosMain.modRL("item_information/pagination/float");
    private static final ResourceLocation PAGINATION_FLOAT_PRESS_TEXT = IosMain.modRL("item_information/pagination/float_press");
    private static final ResourceLocation PAGINATION_SELECTED_TEXT = IosMain.modRL("item_information/pagination/selected");
    private static final ResourceLocation PAGINATION_SELECTED_FLOAT_TEXT = IosMain.modRL("item_information/pagination/selected_float");
    private static final ResourceLocation PAGINATION_SELECTED_FLOAT_PRESS_TEXT = IosMain.modRL("item_information/pagination/selected_float_press");
    private static final ResourceLocation PAGINATION_SELECTED_PRESS_TEXT = IosMain.modRL("item_information/pagination/selected_press");
    private static final ResourceLocation PAGINATION_SWITCH_TEXT = IosMain.modRL("item_information/pagination/switch");
    private static final ResourceLocation COPY_TEXT = IosMain.modRL("item_information/copy");
    private static final ResourceLocation COPY_PRESS_TEXT = IosMain.modRL("item_information/copy_press");
    private static final WidgetSprites PAGINATION_SPRITES = new WidgetSprites(PAGINATION_DEFAULT_TEXT, PAGINATION_SELECTED_PRESS_TEXT, PAGINATION_SELECTED_TEXT, PAGINATION_SELECTED_PRESS_TEXT);
    private static final WidgetSprites PAGINATION_SWITCH_SPRITES = new WidgetSprites(PAGINATION_SWITCH_TEXT, PAGINATION_SWITCH_TEXT);
    private static final WidgetSprites COPY_SPRITES = new WidgetSprites(COPY_TEXT, COPY_PRESS_TEXT);
    private static final MutableComponent PROVIDER_TEXT_COMPONENT = Component.translatable((String)"item_information_screen.provider.text.component");
    private static final MutableComponent PROVIDER_TEXT_DATA = Component.translatable((String)"item_information_screen.provider.text.data");
    private static final MutableComponent PROVIDER_TEXT_DEFAULT = Component.translatable((String)"item_information_screen.provider.text.default");
    private static final MutableComponent PROVIDER_TEXT_EXTRA = Component.translatable((String)"item_information_screen.provider.text.extra");
    private static final MutableComponent PROVIDER_TEXT_SWITCH = Component.translatable((String)"item_information_screen.provider.text.switch");
    private static final MutableComponent TEXT_COPY = Component.translatable((String)"item_information_screen.text.copy");
    protected final int scissorLeft = 10;
    protected final int scissorTop = 45;
    protected final int scissorRight = 219;
    protected final int scissorBottom = 208;
    protected final int imageWidth = 230;
    protected final int imageHeight = 220;
    private final ItemStack item;
    private final List<Pagination> paginationList;
    protected int leftPos;
    protected int topPos;
    private int page;

    public ItemInformationScreen(Container container, ItemStack item) {
        super(TITLE);
        this.item = item;
        this.paginationList = new ArrayList<Pagination>(4);
    }

    public static int getColor(String colorText) {
        return ((TextColor)TextColor.parseColor((String)colorText).getOrThrow()).getValue();
    }

    private static void displayClientMessage(LocalPlayer player, Component textComponent) {
        player.displayClientMessage(textComponent, false);
    }

    private static Component copyOnClickText(MutableComponent component, Component copyComponent) {
        return ItemInformationScreen.copyOnClickText(component, copyComponent, (Component)Component.translatable((String)"chat.copy.click"));
    }

    private static Component copyOnClickText(MutableComponent component, Component copyComponent, Component clickComponent) {
        String copyText = copyComponent.toString();
        return ComponentUtils.wrapInSquareBrackets((Component)component.withStyle(style -> style.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, copyText)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)clickComponent)).withInsertion(copyText))).append("\n").append(copyComponent);
    }

    protected void init() {
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        if (this.minecraft == null) {
            throw new NullPointerException("minecraft is null");
        }
        if (this.minecraft.level == null) {
            throw new NullPointerException("level is null");
        }
        this.paginationList.clear();
        RegistryAccess provider = this.minecraft.level.registryAccess();
        this.paginationList.add(new Pagination((Component)PROVIDER_TEXT_COMPONENT, this, ModNbtUtil.getDataComponentsNbt(this.item, provider), this.font));
        this.paginationList.add(new Pagination((Component)PROVIDER_TEXT_DATA, this, ModNbtUtil.getItemNbt(this.item, (HolderLookup.Provider)provider), this.font));
        this.paginationList.add(new Pagination((Component)PROVIDER_TEXT_DEFAULT, this, ModNbtUtil.getDefaultDataComponentsNbt(this.item, (HolderLookup.Provider)provider), this.font));
        this.paginationList.add(new Pagination((Component)PROVIDER_TEXT_EXTRA, this, ModNbtUtil.getExtraDataComponentsNbt(this.item, (HolderLookup.Provider)provider), this.font));
        int paginationIndex = 0;
        int paginationImageButtonPoX = this.leftPos + 11;
        int paginationImageButtonPoY = this.topPos + 29;
        for (Pagination pagination : this.paginationList) {
            pagination.init();
            int finalIndex = paginationIndex++;
            Component component = pagination.getComponent();
            int width = this.font.width((FormattedText)component) + 6;
            this.addRenderableWidget((GuiEventListener)TextImageButton.builder().text(this.font, component, 3).color("#ffffff").build(paginationImageButtonPoX, paginationImageButtonPoY, width, 14, PAGINATION_SPRITES, component, button -> this.setPage(finalIndex)));
            paginationImageButtonPoX += width + 1;
        }
        this.renderables.stream().filter((Predicate<Renderable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$init$2(net.minecraft.client.gui.components.Renderable ), (Lnet/minecraft/client/gui/components/Renderable;)Z)()).map((Function<Renderable, TextImageButton>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$init$3(net.minecraft.client.gui.components.Renderable ), (Lnet/minecraft/client/gui/components/Renderable;)Lxiaojin/itemoverlaystate/client/gui/widget/TextImageButton;)()).findFirst().get().press = true;
        ImageButton switchWidget = new ImageButton(this.leftPos - 14, this.topPos + 29, 16, 17, PAGINATION_SWITCH_SPRITES, button -> {
            ++this.page;
            if (this.page >= this.paginationList.size()) {
                this.page = 0;
            }
            this.setPage(this.page);
        });
        switchWidget.setTooltip(Tooltip.create((Component)PROVIDER_TEXT_SWITCH));
        this.addRenderableWidget((GuiEventListener)switchWidget);
        ImageButton copyWidget = new ImageButton(this.leftPos + 207, this.topPos + 46, 12, 12, COPY_SPRITES, button -> this.minecraft.keyboardHandler.setClipboard(this.getNbtText()));
        copyWidget.setTooltip(Tooltip.create((Component)TEXT_COPY));
        this.addRenderableWidget((GuiEventListener)copyWidget);
    }

    public final int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
        List<TextImageButton> textImageButtonList = this.renderables.stream().filter(r -> r instanceof TextImageButton).map(r -> (TextImageButton)((Object)r)).toList();
        textImageButtonList.forEach(button1 -> {
            button1.press = false;
        });
        textImageButtonList.get((int)page).press = true;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack pose = guiGraphics.pose();
        guiGraphics.renderItem(this.item, this.leftPos + 8, this.topPos + 8);
        guiGraphics.drawString(this.font, this.item.getHoverName(), this.leftPos + 28, this.topPos + 12, ItemInformationScreen.getColor("#ffffff"));
        this.renderNbtText(guiGraphics, pose);
    }

    protected void renderNbtText(GuiGraphics guiGraphics, PoseStack pose) {
        guiGraphics.enableScissor(this.leftPos + 10, this.topPos + 45, this.leftPos + 219, this.topPos + 208);
        pose.pushPose();
        List<FormattedCharSequence> nbtText = this.getNbtTextList();
        int nbtTextSize = nbtText.size();
        for (int i = 0; i < nbtTextSize; ++i) {
            Objects.requireNonNull(this.font);
            int lineHeight = 9;
            int y = this.topPos + this.getNbtTextPositionY() + i * (lineHeight + 1);
            int minY = this.topPos + 45 - lineHeight;
            int maxY = this.topPos + 208 + lineHeight;
            if (y < minY || y > maxY) continue;
            guiGraphics.drawString(this.font, nbtText.get(i), this.leftPos + this.getNbtTextPositionX(), y, 0xFFFFFF);
        }
        pose.popPose();
        guiGraphics.disableScissor();
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean is = super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        if (mouseX >= (double)(this.leftPos + 10) && mouseX <= (double)(this.leftPos + 219) && mouseY >= (double)(this.topPos + 45) && mouseY <= (double)(this.topPos + 208)) {
            if (this.getNbtTextWidth() > 209) {
                this.setNbtTextPositionX(this.getNbtTextPositionX() + (int)dragX);
            }
            if (this.getNbtTextHeight() > 163) {
                this.setNbtTextPositionY(this.getNbtTextPositionY() + (int)dragY);
            }
        }
        return is;
    }

    public void renderMenuBackground(GuiGraphics guiGraphics) {
        guiGraphics.blit(BG_TEXTURE, this.leftPos, this.topPos, 0, 0.0f, 0.0f, 230, 220, 256, 256);
    }

    public ItemStack getStack() {
        return this.item;
    }

    public List<FormattedCharSequence> getNbtTextList() {
        return this.getPagination().getNbtTextList();
    }

    public int getNbtTextWidth() {
        return this.getPagination().getNbtTextWidth();
    }

    public int getNbtTextHeight() {
        return this.getPagination().getNbtTextHeight();
    }

    public int getNbtTextPositionX() {
        return this.getPagination().getNbtTextPositionX();
    }

    public void setNbtTextPositionX(int x) {
        this.getPagination().setNbtTextPositionX(Math.clamp((long)x, -this.getNbtTextWidth() + 219, 12));
    }

    public int getNbtTextPositionY() {
        return this.getPagination().getNbtTextPositionY();
    }

    public void setNbtTextPositionY(int y) {
        this.getPagination().setNbtTextPositionY(Math.clamp((long)y, -this.getNbtTextHeight() + 208, 47));
    }

    public String getNbtText() {
        return this.getPagination().getNbtText();
    }

    public Pagination getPagination() {
        return this.paginationList.get(this.page);
    }

    private static /* synthetic */ TextImageButton lambda$init$3(Renderable r) {
        return (TextImageButton)r;
    }

    private static /* synthetic */ boolean lambda$init$2(Renderable r) {
        return r instanceof TextImageButton;
    }

    public static class Pagination {
        private final List<FormattedCharSequence> nbtTextList;
        private final Component component;
        private final ItemInformationScreen screen;
        private final CompoundTag nbt;
        @NotNull
        private final Font font;
        private final String nbtText;
        private int nbtTextPositionX = 12;
        private int nbtTextPositionY = 47;
        private int nbtTextWidth = 219;
        private int nbtTextHeight = 208;

        public Pagination(Component component, ItemInformationScreen screen, CompoundTag nbt, @NotNull Font font) {
            this.component = component;
            this.screen = screen;
            this.nbt = nbt;
            this.font = font;
            Component mutableComponent = this.getMutableComponent(this.nbt);
            this.nbtTextList = this.toPrettyComponent(mutableComponent);
            this.nbtText = mutableComponent.getString();
        }

        @NotNull
        public List<FormattedCharSequence> toPrettyComponent(Component text) {
            return ComponentRenderUtils.wrapComponents((FormattedText)text, (int)Integer.MAX_VALUE, (Font)this.font);
        }

        @NotNull
        public Component getMutableComponent(CompoundTag nbt) {
            return new TextComponentTagVisitor("  ").visit((Tag)nbt);
        }

        public void init() {
            this.setNbtTextWidth(this.nbtTextList.stream().map(arg_0 -> ((Font)this.font).width(arg_0)).max(Integer::compareTo).get());
            int n = this.nbtTextList.size();
            Objects.requireNonNull(this.font);
            this.setNbtTextHeight(n * (9 + 1));
        }

        public int getNbtTextPositionX() {
            return this.nbtTextPositionX;
        }

        public void setNbtTextPositionX(int x) {
            this.nbtTextPositionX = Math.clamp((long)x, -this.nbtTextWidth + this.screen.scissorRight, this.screen.scissorLeft + 2);
        }

        public int getNbtTextPositionY() {
            return this.nbtTextPositionY;
        }

        public void setNbtTextPositionY(int y) {
            this.nbtTextPositionY = Math.clamp((long)y, -this.nbtTextHeight + this.screen.scissorBottom, this.screen.scissorTop + 2);
        }

        public int getNbtTextWidth() {
            return this.nbtTextWidth;
        }

        public void setNbtTextWidth(int nbtTextWidth) {
            this.nbtTextWidth = nbtTextWidth;
        }

        public int getNbtTextHeight() {
            return this.nbtTextHeight;
        }

        public void setNbtTextHeight(int nbtTextHeight) {
            this.nbtTextHeight = nbtTextHeight;
        }

        public CompoundTag getNbt() {
            return this.nbt;
        }

        public List<FormattedCharSequence> getNbtTextList() {
            return this.nbtTextList;
        }

        public Component getComponent() {
            return this.component;
        }

        public String getNbtText() {
            return this.nbtText;
        }
    }
}

