/*
 * Decompiled with CFR 0.152.
 */
package xiaojin.itemoverlaystate.client.gui.widget;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import xiaojin.itemoverlaystate.client.gui.screen.ItemInformationScreen;

@OnlyIn(value=Dist.CLIENT)
public class TextImageButton
extends ImageButton {
    @Nullable
    private final Font font;
    @Nullable
    private final Component text;
    private final int color;
    private final int textMargin;
    public boolean press;

    public TextImageButton(int x, int y, int width, int height, WidgetSprites sprites, Component message, Button.OnPress onPress, Builder builder) {
        super(x, y, width, height, sprites, onPress, message);
        this.font = builder.font;
        this.text = builder.text;
        this.color = builder.color;
        this.textMargin = builder.textMargin;
        this.setTooltip(builder.tooltip);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ResourceLocation resourcelocation = this.sprites.get(!this.isPress(), this.isHoveredOrFocused());
        guiGraphics.blitSprite(resourcelocation, this.getX(), this.getY(), this.width, this.height);
        this.renderText(guiGraphics);
    }

    public void renderText(GuiGraphics guiGraphics) {
        if (this.text == null || this.font == null) {
            return;
        }
        int x = this.getX() + this.textMargin;
        int n = this.getY();
        int n2 = this.getHeight();
        Objects.requireNonNull(this.font);
        int y = n + (n2 - 9) / 2 - (this.isPress() ? -2 : 0);
        guiGraphics.drawString(this.font, this.getMessage(), x, y, this.color);
    }

    public int getTextMargin() {
        return this.textMargin;
    }

    public Component getText() {
        return this.text;
    }

    public boolean isPress() {
        return this.press;
    }

    public static class Builder {
        @Nullable
        private Component text;
        private Font font;
        private int textMargin = 0;
        @Nullable
        private Tooltip tooltip;
        private int color;

        public Builder() {
            this.font = Minecraft.getInstance().font;
        }

        public Builder text(Font font, Component component, int textMargin) {
            this.font = font;
            this.text = component;
            this.textMargin = textMargin;
            return this;
        }

        public Builder text(Component text) {
            this.text = text;
            return this;
        }

        public Builder font(Font font) {
            this.font = font;
            return this;
        }

        public Builder textMargin(int textMargin) {
            this.textMargin = textMargin;
            return this;
        }

        public Builder color(int color) {
            this.color = color;
            return this;
        }

        public Builder color(String rgbString) {
            this.color = ItemInformationScreen.getColor(rgbString);
            return this;
        }

        public Builder tooltip(@Nullable Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public TextImageButton build(int x, int y, int width, int height, WidgetSprites sprites, Component message, Button.OnPress onPress) {
            return new TextImageButton(x, y, width, height, sprites, message, onPress, this);
        }
    }
}

