/*
 * Decompiled with CFR 0.152.
 */
package xiaojin.itemoverlaystate.client.override;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.common.CommonHooks;

public class EnchantmentConditionChecker {
    public static boolean enchantment(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity livingEntity, JsonElement json, int seed) {
        if (!json.isJsonObject()) {
            return true;
        }
        HolderLookup.RegistryLookup lookup = CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT);
        if (lookup == null) {
            return true;
        }
        JsonObject jsonObject = json.getAsJsonObject();
        Map<ResourceLocation, Integer> enchantments = EnchantmentConditionChecker.getEnchantmentMap(stack, (HolderLookup.RegistryLookup<Enchantment>)lookup);
        for (Map.Entry entry : jsonObject.entrySet()) {
            ResourceLocation key = ResourceLocation.parse((String)((String)entry.getKey()));
            if (!enchantments.containsKey(key)) {
                return false;
            }
            if (enchantments.get(key) >= ((JsonElement)entry.getValue()).getAsShort()) continue;
            return false;
        }
        return true;
    }

    public static boolean includeEnchantment(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity livingEntity, JsonElement json, int seed) {
        if (!(json.isJsonPrimitive() && json.getAsJsonPrimitive().isString() || json.isJsonArray())) {
            return true;
        }
        HolderLookup.RegistryLookup lookup = CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT);
        if (lookup == null) {
            return true;
        }
        if (json.isJsonPrimitive()) {
            Map<ResourceLocation, Integer> enchantments = EnchantmentConditionChecker.getEnchantmentMap(stack, (HolderLookup.RegistryLookup<Enchantment>)lookup);
            return enchantments.containsKey(ResourceLocation.parse((String)json.getAsString()));
        }
        if (json.isJsonArray()) {
            for (JsonElement textElement : json.getAsJsonArray()) {
                Map<ResourceLocation, Integer> enchantments;
                if (!textElement.isJsonPrimitive() || !textElement.getAsJsonPrimitive().isString() || (enchantments = EnchantmentConditionChecker.getEnchantmentMap(stack, (HolderLookup.RegistryLookup<Enchantment>)lookup)).containsKey(ResourceLocation.parse((String)textElement.getAsString()))) continue;
                return false;
            }
        }
        return true;
    }

    private static Map<ResourceLocation, Integer> getEnchantmentMap(ItemStack stack, HolderLookup.RegistryLookup<Enchantment> lookup) {
        HashMap<ResourceLocation, Integer> enchantmentsMap = new HashMap<ResourceLocation, Integer>();
        if (lookup == null) {
            return enchantmentsMap;
        }
        ItemEnchantments enchantments = stack.getAllEnchantments(lookup);
        for (Object2IntMap.Entry entry : enchantments.entrySet()) {
            Holder enchantment = (Holder)entry.getKey();
            ResourceKey key = enchantment.getKey();
            if (key == null) continue;
            enchantmentsMap.put(key.location(), enchantments.getLevel(enchantment));
        }
        return enchantmentsMap;
    }
}

