/*
 * Decompiled with CFR 0.152.
 */
package xiaojin.itemoverlaystate.client.override;

import com.google.gson.JsonElement;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import xiaojin.itemoverlaystate.util.IosUtil;

public class ItemStackConditionChecker {
    public static boolean stacking(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity livingEntity, JsonElement json, int seed) {
        if (!json.isJsonPrimitive()) {
            return false;
        }
        int count = stack.getCount();
        if (!IosUtil.numericalJudgment(json, count)) {
            return IosUtil.percentageJudgment(json, count, stack.getMaxStackSize());
        }
        return true;
    }

    public static boolean damage(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity livingEntity, JsonElement json, int seed) {
        if (!json.isJsonPrimitive()) {
            return false;
        }
        int damage = stack.getDamageValue();
        if (!IosUtil.numericalJudgment(json, damage)) {
            return IosUtil.percentageJudgment(json, damage, stack.getMaxDamage());
        }
        return true;
    }

    public static boolean name(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity livingEntity, JsonElement json, int seed) {
        if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isString()) {
            return false;
        }
        return Pattern.compile(json.getAsString()).matcher(stack.getDisplayName().getString()).matches();
    }
}

