/*
 * Decompiled with CFR 0.152.
 */
package xiaojin.itemoverlaystate.client.override;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import xiaojin.itemoverlaystate.util.ModNbtUtil;

public class NBTConditionChecker {
    public static boolean nbt(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity livingEntity, JsonElement json, int seed) {
        if (level == null || !json.isJsonObject()) {
            return true;
        }
        CompoundTag nbt = ModNbtUtil.getItemNbt(stack, (HolderLookup.Provider)level.registryAccess());
        for (Map.Entry textElement : json.getAsJsonObject().entrySet()) {
            if (nbt.contains((String)textElement.getKey())) continue;
            return false;
        }
        return NBTConditionChecker.areNBTEquals((Tag)nbt, json);
    }

    public static boolean includeNbt(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity livingEntity, JsonElement json, int seed) {
        if (!(level != null && (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString() || json.isJsonArray()))) {
            return true;
        }
        CompoundTag nbt = ModNbtUtil.getItemNbt(stack, (HolderLookup.Provider)level.registryAccess());
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
            return nbt.contains(json.getAsString());
        }
        if (json.isJsonArray()) {
            for (JsonElement textElement : json.getAsJsonArray()) {
                if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isString() || nbt.contains(textElement.getAsString())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean components(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity livingEntity, JsonElement json, int seed) {
        if (level == null || !json.isJsonObject()) {
            return true;
        }
        for (Map.Entry jsonElement : json.getAsJsonObject().entrySet()) {
            DataComponentType key = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.parse((String)((String)jsonElement.getKey())));
            if (key == null || stack.getComponents().has(key)) continue;
            return false;
        }
        return NBTConditionChecker.areNBTEquals((Tag)ModNbtUtil.getDataComponentsNbt(stack, level.registryAccess()), json);
    }

    public static boolean includeComponents(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity livingEntity, JsonElement json, int seed) {
        if (!json.isJsonPrimitive() || !json.isJsonArray()) {
            return true;
        }
        DataComponentMap components = stack.getComponents();
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
            DataComponentType key = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.parse((String)json.getAsString()));
            if (key == null) {
                return true;
            }
            return components.has(key);
        }
        if (json.isJsonArray()) {
            for (JsonElement jsonElement : json.getAsJsonArray()) {
                DataComponentType key;
                if (!json.isJsonPrimitive() || !json.getAsJsonPrimitive().isString() || (key = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(ResourceLocation.parse((String)jsonElement.getAsString()))) == null || components.has(key)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean areNBTEquals(Tag itemNbt, JsonElement json) {
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            for (JsonElement element : array) {
                if (NBTConditionChecker.areNBTEquals(itemNbt, element)) continue;
                return false;
            }
        } else if (json.isJsonObject() && itemNbt instanceof CompoundTag) {
            CompoundTag itemNbt1 = (CompoundTag)itemNbt;
            JsonObject object = json.getAsJsonObject();
            for (Map.Entry entry : object.entrySet()) {
                String key = (String)entry.getKey();
                if (!itemNbt1.contains(key)) {
                    return false;
                }
                Tag nbt = itemNbt1.get(key);
                JsonElement value = (JsonElement)entry.getValue();
                Tag tag = nbt;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EndTag.class, NumericTag.class, CollectionTag.class, StringTag.class, CompoundTag.class}, (Object)tag, n)) {
                    case 0: {
                        EndTag endTag = (EndTag)tag;
                        if (!NBTConditionChecker.areNBTEqualsAEnd(endTag)) break;
                        return false;
                    }
                    case 1: {
                        NumericTag numericTag = (NumericTag)tag;
                        if (!NBTConditionChecker.areNBTEqualsANumber(value, numericTag)) break;
                        return false;
                    }
                    case 2: {
                        CollectionTag collectionTag = (CollectionTag)tag;
                        if (!NBTConditionChecker.areNBTEqualsAArray(value, collectionTag)) break;
                        return false;
                    }
                    case 3: {
                        StringTag stringTag = (StringTag)tag;
                        if (!NBTConditionChecker.areNBTEqualsAString(value, stringTag)) break;
                        return false;
                    }
                    case 4: {
                        CompoundTag compoundTag = (CompoundTag)tag;
                        if (!NBTConditionChecker.areNBTEqualsACompound(value, compoundTag)) break;
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean areNBTEqualsACompound(JsonElement value, CompoundTag nbt) {
        return !value.isJsonObject() || !NBTConditionChecker.areNBTEquals((Tag)nbt, value);
    }

    private static boolean areNBTEqualsAString(JsonElement value, StringTag nbt) {
        return !value.isJsonPrimitive() || !value.getAsJsonPrimitive().isString() || !value.getAsString().equals(nbt.getAsString());
    }

    private static boolean areNBTEqualsAArray(JsonElement value, CollectionTag<?> nbt) {
        if (!value.isJsonArray()) {
            return true;
        }
        CollectionTag<?> collectionTag = nbt;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ByteArrayTag.class, IntArrayTag.class, LongArrayTag.class, ListTag.class}, collectionTag, n)) {
            case 0: {
                ByteArrayTag tagArray = (ByteArrayTag)collectionTag;
                ArrayList<Byte> list = new ArrayList<Byte>();
                for (byte b : tagArray.getAsByteArray()) {
                    list.add(b);
                }
                Object object = value.getAsJsonArray().iterator();
                while (object.hasNext()) {
                    JsonElement element = (JsonElement)object.next();
                    if (list.contains(element.getAsByte())) continue;
                    return true;
                }
                break;
            }
            case 1: {
                IntArrayTag tagArray = (IntArrayTag)collectionTag;
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int i : tagArray.getAsIntArray()) {
                    list.add(i);
                }
                Object element = value.getAsJsonArray().iterator();
                while (element.hasNext()) {
                    JsonElement element2 = (JsonElement)element.next();
                    if (list.contains(element2.getAsInt())) continue;
                    return true;
                }
                break;
            }
            case 2: {
                LongArrayTag tagArray = (LongArrayTag)collectionTag;
                ArrayList<Long> list = new ArrayList<Long>();
                for (long l : tagArray.getAsLongArray()) {
                    list.add(l);
                }
                Object object = value.getAsJsonArray().iterator();
                while (object.hasNext()) {
                    JsonElement element = (JsonElement)object.next();
                    if (list.contains(element.getAsLong())) continue;
                    return true;
                }
                break;
            }
            case 3: {
                ListTag tagArray = (ListTag)collectionTag;
                for (Tag tag : tagArray) {
                    if (NBTConditionChecker.areNBTEquals(tag, value)) continue;
                    return true;
                }
                break;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    private static boolean areNBTEqualsANumber(JsonElement value, NumericTag nbt) {
        if (!value.isJsonPrimitive()) {
            return true;
        }
        JsonPrimitive primitive = value.getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            if (nbt instanceof ByteTag) {
                ByteTag tag = (ByteTag)nbt;
                return tag.getAsByte() == 0 == primitive.getAsBoolean();
            }
        } else {
            if (primitive.isNumber()) {
                Number number = primitive.getAsNumber();
                NumericTag numericTag = nbt;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ByteTag.class, ShortTag.class, IntTag.class, LongTag.class, FloatTag.class, DoubleTag.class}, (Object)numericTag, n)) {
                    case 0 -> {
                        ByteTag tag = (ByteTag)numericTag;
                        if (tag.getAsByte() < number.byteValue()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 1 -> {
                        ShortTag tag = (ShortTag)numericTag;
                        if (tag.getAsShort() < number.shortValue()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 2 -> {
                        IntTag tag = (IntTag)numericTag;
                        if (tag.getAsInt() < number.intValue()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 3 -> {
                        LongTag tag = (LongTag)numericTag;
                        if (tag.getAsLong() < number.longValue()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 4 -> {
                        FloatTag tag = (FloatTag)numericTag;
                        if (tag.getAsFloat() < number.floatValue()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 5 -> {
                        DoubleTag tag = (DoubleTag)numericTag;
                        if (tag.getAsDouble() < number.doubleValue()) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> true;
                };
            }
            return true;
        }
        return false;
    }

    private static boolean areNBTEqualsAEnd(EndTag nbt) {
        return false;
    }
}

