/*
 * Decompiled with CFR 0.152.
 */
package xiaojin.itemoverlaystate.util;

import com.google.gson.JsonElement;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;

public class IosUtil {
    public static final Pattern PERCENTAGE = Pattern.compile("^ *-?\\d+(\\.\\d+)?% *$");
    public static final Pattern EXTRACT_NUMBER = Pattern.compile(" *-?\\d+(\\.\\d+)? *");

    public static boolean numericalJudgment(JsonElement element, int count) {
        return element.getAsJsonPrimitive().isNumber() && count >= element.getAsJsonPrimitive().getAsInt();
    }

    public static boolean percentageJudgment(JsonElement element, float count, int maxCount) {
        if (!element.getAsJsonPrimitive().isString()) {
            return false;
        }
        String value = element.getAsString().toLowerCase().trim();
        if (!PERCENTAGE.matcher(value).matches()) {
            return false;
        }
        return count / (float)maxCount >= IosUtil.getAFloat(value) / 100.0f;
    }

    public static float getAFloat(String value) {
        Matcher matcher = EXTRACT_NUMBER.matcher(value);
        if (matcher.find()) {
            return Float.parseFloat(matcher.group());
        }
        return 0.0f;
    }

    public static boolean ios$includeIos(List<ResourceLocation> properties) {
        for (ResourceLocation rl : properties) {
            if (!rl.getPath().startsWith("ios:")) continue;
            return true;
        }
        return false;
    }
}

