/*
 * Decompiled with CFR 0.152.
 */
package xiaojin.itemoverlaystate.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import xiaojin.itemoverlaystate.IosMain;

public class ModNbtUtil {
    public static CompoundTag getDataComponentsNbt(DataComponentMap map, HolderLookup.Provider provider) {
        CompoundTag component = new CompoundTag();
        for (TypedDataComponent entry : map) {
            ModNbtUtil.getDataComponentsNbt(provider, entry, component);
        }
        return component;
    }

    public static <T, D extends DataComponentType<T>> void getDataComponentsNbt(HolderLookup.Provider provider, TypedDataComponent<T> entry, CompoundTag compound) {
        DataComponentType type = entry.type();
        ResourceLocation key = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)type);
        Codec tCodec = type.codec();
        if (key == null || tCodec == null) {
            return;
        }
        Object value = entry.value();
        try {
            compound.put(key.toString(), (Tag)tCodec.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), value).getOrThrow());
        }
        catch (IllegalStateException e) {
            IosMain.LOGGER.error("Failed to encode DataComponentType: {}", entry, (Object)e);
        }
    }

    @NotNull
    public static CompoundTag getDataComponentsNbt(ItemStack item, RegistryAccess provider) {
        return ModNbtUtil.getDataComponentsNbt(item.getComponents(), (HolderLookup.Provider)provider);
    }

    @NotNull
    public static CompoundTag getItemNbt(ItemStack item, HolderLookup.Provider provider) {
        return (CompoundTag)item.saveOptional(provider);
    }

    @NotNull
    public static CompoundTag getDefaultDataComponentsNbt(ItemStack item, HolderLookup.Provider provider) {
        return ModNbtUtil.getDataComponentsNbt(item.getPrototype(), provider);
    }

    @NotNull
    public static CompoundTag getExtraDataComponentsNbt(ItemStack item, HolderLookup.Provider provider) {
        return ModNbtUtil.getDataComponentsNbt((DataComponentMap)PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.builder().build(), (DataComponentPatch)item.getComponentsPatch()), provider);
    }
}

