/*
 * Decompiled with CFR 0.152.
 */
package dev.cattyn.shulkerview.handler;

import dev.cattyn.shulkerview.Globals;
import dev.cattyn.shulkerview.ShulkerViewEntrypoint;
import dev.cattyn.shulkerview.mixin.DuckHandledScreen;
import dev.cattyn.shulkerview.utils.ShulkerInfo;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import org.joml.Math;
import org.joml.Vector2d;

public class RenderHandler
implements Globals {
    private static final int MARGIN = 2;
    private static final int GRID_WIDTH = 20;
    private static final int GRID_HEIGHT = 18;
    private final Vector2d clicked = new Vector2d();
    private int height;
    private int offset;
    private int rows;
    private int cols;
    private int startX;
    private int currentY;

    public void render(class_332 context, double mouseX, double mouseY) {
        boolean right = false;
        this.startX = 2;
        this.currentY = this.usesBoth() ? 2 : 2 + this.offset;
        context.method_51448().method_22903();
        context.method_51448().method_22905(this.scale(), this.scale(), 1.0f);
        for (ShulkerInfo shulkerInfo : ShulkerViewEntrypoint.getInstance().getUpdateHandler().getShulkerList()) {
            this.updateShulkerInfo(shulkerInfo);
            if ((float)this.currentY >= (float)context.method_51443() / this.scale() && this.usesBoth() && !right) {
                right = true;
                this.currentY = 2 + this.offset;
            }
            if (right) {
                float scaledGridWidth = 20.0f * this.scale();
                this.startX = (int)(((float)context.method_51421() - (float)this.cols * scaledGridWidth - 2.0f) / this.scale());
            }
            this.drawShulkerInfo(context, shulkerInfo);
        }
        context.method_51452();
        context.method_51448().method_22909();
        this.height = this.currentY - this.offset;
        this.clicked.set(0.0);
    }

    private void drawShulkerInfo(class_332 context, ShulkerInfo info) {
        int cols = this.cols * 18;
        int rows = this.rows * 20;
        int width = cols + 2 * this.cols;
        int x = this.startX;
        int y = this.currentY;
        int count = 0;
        if ((float)this.currentY * this.scale() < (float)context.method_51443()) {
            for (class_1799 stack : info.stacks()) {
                if (info.compact() && stack.method_7960()) break;
                int column = x + count % 9 * 20 + 2;
                int row = y + count / 9 * 18 + 2;
                this.drawStack(context, stack, column, row);
                ++count;
            }
            if (count == 0 && info.compact()) {
                context.method_51427(info.shulker(), x + 2, this.currentY + 2);
            }
            if (this.clicked.lengthSquared() != 0.0 && this.isHovered(this.clicked.x, this.clicked.y, width, rows)) {
                int id = RenderHandler.mc.field_1724.field_7512.field_7763;
                RenderHandler.mc.field_1761.method_2906(id, info.slot(), 0, class_1713.field_7790, (class_1657)RenderHandler.mc.field_1724);
                this.clicked.set(0.0);
            }
            int background = ShulkerViewEntrypoint.getInstance().getConfig().getBackground();
            context.method_25294(x, y, x + width, y + rows, background);
            context.method_25294(x, y - 1, x + width, y, info.color());
        }
        this.currentY += rows + 2;
    }

    public void mouseClick(double x, double y, int button) {
        if (button != 0) {
            return;
        }
        this.clicked.set(x, y);
    }

    public void mouseScroll(double x, double y, double amount) {
        DuckHandledScreen screen;
        class_1735 slot;
        if (amount == 0.0) {
            return;
        }
        class_437 class_4372 = RenderHandler.mc.field_1755;
        if (class_4372 instanceof DuckHandledScreen && (slot = (screen = (DuckHandledScreen)class_4372).shulker_view$getFocused()) != null && slot.method_7677().method_31574(class_1802.field_27023)) {
            return;
        }
        float f = Math.min((float)((float)(-this.height) + (float)mc.method_22683().method_4502() / this.scale()), (float)0.0f);
        this.offset = (int)class_3532.method_15350((double)((double)this.offset + Math.ceil((double)amount) * 10.0), (double)f, (double)0.0);
    }

    private boolean isHovered(double x, double y, float cols, float rows) {
        return (x /= (double)this.scale()) >= (double)this.startX && x <= (double)((float)this.startX + cols) && (y /= (double)this.scale()) >= (double)this.currentY && y <= (double)((float)this.currentY + rows);
    }

    private void drawStack(class_332 ctx, class_1799 stack, int x, int y) {
        ctx.method_51427(stack, x, y);
        if (stack.method_7947() > 999) {
            String text = "%.1fk".formatted(Float.valueOf((float)stack.method_7947() / 1000.0f));
            ctx.method_51432(RenderHandler.mc.field_1772, stack, x, y, text);
        } else {
            ctx.method_51431(RenderHandler.mc.field_1772, stack, x, y);
        }
    }

    private void updateShulkerInfo(ShulkerInfo info) {
        int size = info.stacks().size();
        if (info.compact()) {
            size = 0;
            for (class_1799 s : info.stacks()) {
                if (s.method_7960()) break;
                ++size;
            }
            size = Math.max((int)1, (int)size);
        }
        this.rows = (int)Math.ceil((float)((float)size / 9.0f));
        this.cols = class_3532.method_15340((int)size, (int)1, (int)9);
    }

    private boolean usesBoth() {
        return ShulkerViewEntrypoint.getInstance().getConfig().isBothSides();
    }

    private float scale() {
        return ShulkerViewEntrypoint.getInstance().getConfig().getScale();
    }
}

