/*
 * Decompiled with CFR 0.152.
 */
package me.zipestudio.hudless.backend;

import java.util.Objects;
import me.zipestudio.hudless.client.HLClient;
import me.zipestudio.hudless.config.HLConfig;
import me.zipestudio.hudless.config.HudElement;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.joml.Matrix3x2fStack;

public class HudAnimationHandler {
    private static double y = 0.0;
    private static double speed = 0.0;
    private static int alpha = 255;
    private static long lastHudVisibleTime;

    public static double getY() {
        HLConfig config = HLClient.getConfig();
        return -Math.min(Math.max(Objects.isNull(class_310.method_1551().field_1755) ? y : (double)config.getMaxY(), (double)config.getMinY()), (double)config.getMaxY());
    }

    public static void revealHud() {
        HLConfig config = HLClient.getConfig();
        y = config.getMaxY();
        speed = 0.0;
        alpha = 255;
        if (class_310.method_1551().field_1687 != null) {
            lastHudVisibleTime = class_310.method_1551().field_1687.method_8510();
        }
    }

    public static void render(float delta) {
        HLConfig config = HLClient.getConfig();
        if (!config.isEnableMod()) {
            if (y == (double)config.getMaxY() && speed == 0.0 && alpha == 255) {
                return;
            }
            HudAnimationHandler.revealHud();
            return;
        }
        if (class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_8510() - lastHudVisibleTime >= (long)config.getVisibleTicks()) {
            if (y > (double)config.getMinY()) {
                y -= (speed += config.getHideSpeed() * (double)delta) * (double)delta;
            }
            alpha = Math.max(0, alpha - (int)(config.getHideFadeSpeed() * 255.0 * (double)delta));
        }
    }

    public static boolean beforeInject(HudElement element, class_332 drawContext, boolean useTranslate) {
        Matrix3x2fStack matrices = drawContext.method_51448();
        matrices.pushMatrix();
        HLConfig config = HLClient.getConfig();
        if (!config.isEnableMod() || element.functionDisabled()) {
            return true;
        }
        if (y <= (double)config.getMinY() || HudAnimationHandler.getAlpha() <= 0) {
            matrices.popMatrix();
            return false;
        }
        if (useTranslate) {
            matrices.translate(0.0f, (float)HudAnimationHandler.getY());
        }
        HudElement.currentElement = element;
        return true;
    }

    public static void afterInject(class_332 drawContext) {
        Matrix3x2fStack matrices = drawContext.method_51448();
        matrices.translate(0.0f, (float)HLClient.getConfig().getMaxY());
        matrices.popMatrix();
        HudElement.currentElement = null;
    }

    public static int getAlpha() {
        return alpha;
    }
}

