/*
 * Decompiled with CFR 0.152.
 */
package me.zipestudio.hudless.config;

import java.util.function.Supplier;
import me.zipestudio.hudless.client.HLClient;

public enum HudElement {
    STATUS_BARS(() -> HLClient.getConfig().isHideStatusBars()),
    HOTBAR(() -> HLClient.getConfig().isHideHotbar()),
    HELD_ITEM_TOOLTIP(() -> HLClient.getConfig().isHideHeldItemTooltip()),
    INFO_BAR(() -> HLClient.getConfig().isHideExperienceBar()),
    CROSSHAIR(() -> HLClient.getConfig().isHideCrosshair(), false),
    STATUS_EFFECTS(() -> HLClient.getConfig().isHideEffects(), false),
    MOUNT_HEALTH(() -> HLClient.getConfig().isHideMountHealth()),
    SCOREBOARD(() -> HLClient.getConfig().isHideScoreboardSidebar(), false),
    MISC_OVERLAYS(() -> HLClient.getConfig().isHideMicsOverlays(), false);

    private final Supplier<Boolean> configGetter;
    private final boolean useTranslate;
    public static HudElement currentElement;

    private HudElement(Supplier<Boolean> configGetter) {
        this(configGetter, true);
    }

    private HudElement(Supplier<Boolean> configGetter, boolean useTranslate) {
        this.configGetter = configGetter;
        this.useTranslate = useTranslate;
    }

    public boolean functionDisabled() {
        return this.configGetter.get() == false;
    }

    public boolean isTranslate() {
        return this.useTranslate;
    }

    static {
        currentElement = null;
    }
}

