/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.morebuckets.crafting;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.morebuckets.MoreBuckets;
import com.blakebr0.morebuckets.config.ModConfigs;
import com.blakebr0.morebuckets.crafting.ingredient.FluidBucketIngredient;
import com.blakebr0.morebuckets.item.MoreBucketItem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class RecipeFixer
implements ResourceManagerReloadListener {
    public static final ArrayList<MoreBucketItem> VALID_BUCKETS = new ArrayList();

    public void onResourceManagerReload(ResourceManager manager) {
        if (!((Boolean)ModConfigs.ENABLE_RECIPE_FIXER.get()).booleanValue()) {
            return;
        }
        VALID_BUCKETS.clear();
        for (MoreBucketItem bucket : MoreBucketItem.BUCKETS) {
            if (!bucket.isEnabled()) continue;
            VALID_BUCKETS.add(bucket);
        }
        Collection recipes = RecipeHelper.getAllRecipes();
        for (RecipeHolder recipe : recipes) {
            NonNullList ingredients = recipe.value().getIngredients();
            for (int i = 0; i < ingredients.size(); ++i) {
                Ingredient ingredient = (Ingredient)ingredients.get(i);
                if (ingredient.isCustom()) continue;
                block5: for (Ingredient.Value value : ingredient.getValues()) {
                    if (!(value instanceof Ingredient.ItemValue)) continue;
                    for (ItemStack stack : value.getItems()) {
                        Item item = stack.getItem();
                        if (!(item instanceof BucketItem) && !(item instanceof MilkBucketItem) && !(item instanceof IFluidHandler)) continue;
                        try {
                            ingredients.set(i, (Object)FluidBucketIngredient.of(ingredient));
                            if (!recipe.value().getClass().equals(ShapelessRecipe.class)) continue block5;
                            RecipeFixer.setNotSimple((ShapelessRecipe)recipe.value());
                        }
                        catch (Exception e) {
                            MoreBuckets.LOGGER.warn("Failed to modify ingredients for recipe {}, skipping", (Object)recipe.id());
                        }
                        continue block5;
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)this);
    }

    private static void setNotSimple(ShapelessRecipe recipe) throws NoSuchFieldException, IllegalAccessException {
        Field isSimple = recipe.getClass().getDeclaredField("isSimple");
        isSimple.setAccessible(true);
        isSimple.set(recipe, false);
    }
}

