/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.morebuckets.crafting.ingredient;

import com.blakebr0.cucumber.helper.FluidHelper;
import com.blakebr0.morebuckets.crafting.RecipeFixer;
import com.blakebr0.morebuckets.init.ModIngredientTypes;
import com.blakebr0.morebuckets.item.MoreBucketItem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import org.jetbrains.annotations.Nullable;

public class FluidBucketIngredient
implements ICustomIngredient {
    public static final MapCodec<FluidBucketIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC.fieldOf("parent").forGetter(ingredient -> ingredient.parent)).apply((Applicative)builder, FluidBucketIngredient::new));
    private final Ingredient parent;
    private ItemStack[] stacks;

    public FluidBucketIngredient(Ingredient parent) {
        this.parent = parent;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Optional fluid = FluidUtil.getFluidContained((ItemStack)stack);
        if (fluid.isPresent() && stack.getItem() instanceof MoreBucketItem) {
            return this.getItems().anyMatch(s -> FluidUtil.getFluidContained((ItemStack)s).map(f -> f.is(((FluidStack)fluid.get()).getFluid())).orElse(false));
        }
        return this.parent.test(stack);
    }

    public Stream<ItemStack> getItems() {
        if (this.stacks == null) {
            this.initMatchingStacks();
        }
        return Stream.of(this.stacks);
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return (IngredientType)ModIngredientTypes.FLUID_BUCKET.get();
    }

    private void initMatchingStacks() {
        FluidStack fluid = FluidBucketIngredient.findFluid(this.parent);
        if (fluid != null) {
            ItemStack[] parentStacks = this.parent.getItems();
            ItemStack[] bucketStacks = (ItemStack[])RecipeFixer.VALID_BUCKETS.stream().map(e -> FluidHelper.getFilledBucket((FluidStack)fluid, (Item)e, (int)e.getCapacity())).toArray(ItemStack[]::new);
            ItemStack[] matchingStacks = new ItemStack[parentStacks.length + bucketStacks.length];
            for (int i = 0; i < parentStacks.length; ++i) {
                matchingStacks[i] = parentStacks[i];
            }
            for (int j = parentStacks.length; j < matchingStacks.length; ++j) {
                matchingStacks[j] = bucketStacks[j - parentStacks.length];
            }
            this.stacks = matchingStacks;
        } else {
            this.stacks = this.parent.getItems();
        }
    }

    public static Ingredient of(Ingredient parent) {
        return new Ingredient((ICustomIngredient)new FluidBucketIngredient(parent));
    }

    private static FluidStack findFluid(Ingredient ingredient) {
        for (ItemStack stack : ingredient.getItems()) {
            Optional fluid = FluidUtil.getFluidContained((ItemStack)stack);
            if (!fluid.isPresent()) continue;
            return (FluidStack)fluid.get();
        }
        return null;
    }
}

