/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.morebuckets.item;

import com.blakebr0.cucumber.helper.FluidHelper;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.cucumber.util.Formatting;
import com.blakebr0.morebuckets.bucket.Bucket;
import com.blakebr0.morebuckets.init.ModDataComponentTypes;
import com.blakebr0.morebuckets.lib.ModTooltips;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class MoreBucketItem
extends BaseItem {
    public static final List<MoreBucketItem> BUCKETS = new ArrayList<MoreBucketItem>();
    private final Bucket bucket;

    public MoreBucketItem(Bucket bucket) {
        super(p -> p.stacksTo(1).component(ModDataComponentTypes.BUCKET_CONTENT, (Object)SimpleFluidContent.EMPTY));
        this.bucket = bucket;
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)new DispenserBehavior());
        BUCKETS.add(this);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return FluidHelper.getFluidAmount((ItemStack)stack) > 0;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        ItemStack copy = new ItemStack((ItemLike)this);
        copy.applyComponents(stack.getComponents());
        IFluidHandlerItem tank = (IFluidHandlerItem)copy.getCapability(Capabilities.FluidHandler.ITEM);
        if (tank != null) {
            tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        }
        return copy;
    }

    public int getBarWidth(ItemStack stack) {
        int capacity = this.bucket.getCapacity();
        int stored = capacity - FluidHelper.getFluidAmount((ItemStack)stack);
        return Math.round(13.0f - (float)stored * 13.0f / (float)capacity);
    }

    public int getBarColor(ItemStack stack) {
        int capacity = this.bucket.getCapacity();
        int stored = FluidHelper.getFluidAmount((ItemStack)stack);
        float f = Math.max(0.0f, (float)stored / (float)capacity);
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.bucket.getCapacity() > 1000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return MoreBucketItem.isMilkBucket(stack) ? UseAnim.DRINK : UseAnim.NONE;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return MoreBucketItem.isMilkBucket(stack) ? 32 : 0;
    }

    public int getBurnTime(ItemStack stack, RecipeType<?> type) {
        FluidStack fluid = FluidHelper.getFluidFromStack((ItemStack)stack);
        if (fluid.is((Fluid)Fluids.LAVA) && FluidHelper.getFluidAmount((ItemStack)stack) >= 1000) {
            return 20000;
        }
        return super.getBurnTime(stack, type);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        MutableComponent capacity = Formatting.number((Object)this.bucket.getBuckets());
        int buckets = FluidHelper.getFluidAmount((ItemStack)stack) / 1000;
        FluidStack fluid = FluidHelper.getFluidFromStack((ItemStack)stack);
        if (fluid.isEmpty()) {
            tooltip.add((Component)ModTooltips.BUCKETS.args(new Object[]{buckets, capacity, ModTooltips.EMPTY.build()}).build());
        } else {
            tooltip.add((Component)ModTooltips.BUCKETS.args(new Object[]{buckets, capacity, fluid.getHoverName()}).build());
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (MoreBucketItem.isMilkBucket(stack)) {
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        IFluidHandlerItem tank = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (tank == null) {
            return InteractionResultHolder.fail((Object)stack);
        }
        InteractionResultHolder<ItemStack> pickup = this.tryPickupFluid(stack, level, player);
        if (pickup.getResult() == InteractionResult.SUCCESS) {
            return pickup;
        }
        FluidStack fluid = FluidHelper.getFluidFromStack((ItemStack)stack);
        if (fluid != null && fluid.getAmount() >= 1000) {
            return this.tryPlaceFluid(stack, level, player, hand);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        IFluidHandlerItem tank;
        Cow cow;
        if (entity instanceof Cow && !(cow = (Cow)entity).isBaby() && (tank = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)) != null && tank.fill(new FluidStack((Fluid)NeoForgeMod.MILK.get(), 1000), IFluidHandler.FluidAction.EXECUTE) > 0) {
            player.playSound(SoundEvents.COW_MILK, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        ServerPlayer player;
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            CriteriaTriggers.CONSUME_ITEM.trigger(player, stack);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (!level.isClientSide) {
            entity.removeEffectsCuredBy(EffectCures.MILK);
        }
        if (entity instanceof Player) {
            IFluidHandlerItem tank;
            player = (Player)entity;
            if (!player.getAbilities().instabuild && (tank = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM)) != null) {
                tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            }
        }
        return stack;
    }

    public int getCapacity() {
        return this.bucket.getCapacity();
    }

    public int getSpaceLeft(ItemStack stack) {
        return this.bucket.getCapacity() - FluidHelper.getFluidAmount((ItemStack)stack);
    }

    public boolean isEnabled() {
        return this.bucket.isEnabled();
    }

    private InteractionResultHolder<ItemStack> tryPlaceFluid(ItemStack stack, Level level, Player player, InteractionHand hand) {
        FluidActionResult result;
        BlockPos targetPos;
        if (FluidHelper.getFluidAmount((ItemStack)stack) < 1000) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockHitResult trace = MoreBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (trace.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockPos pos = trace.getBlockPos();
        if (level.mayInteract(player, pos) && player.mayUseItemAt(targetPos = pos.relative(trace.getDirection()), trace.getDirection().getOpposite(), stack) && (result = FluidUtil.tryPlaceFluid((Player)player, (Level)level, (InteractionHand)hand, (BlockPos)targetPos, (ItemStack)stack, (FluidStack)FluidHelper.getFluidFromStack((ItemStack)stack).copyWithAmount(1000))).isSuccess() && !player.getAbilities().instabuild) {
            if (!level.isClientSide()) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, stack);
            }
            return InteractionResultHolder.success((Object)result.getResult());
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    private InteractionResultHolder<ItemStack> tryPickupFluid(ItemStack stack, Level level, Player player) {
        FluidActionResult result;
        Direction direction;
        if (this.getSpaceLeft(stack) < 1000) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockHitResult trace = MoreBucketItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (trace.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)stack);
        }
        BlockPos pos = trace.getBlockPos();
        if (level.mayInteract(player, pos) && player.mayUseItemAt(pos, direction = trace.getDirection(), stack) && (result = FluidUtil.tryPickUpFluid((ItemStack)stack, (Player)player, (Level)level, (BlockPos)pos, (Direction)direction)).isSuccess() && !player.getAbilities().instabuild) {
            if (!level.isClientSide()) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, stack);
            }
            return InteractionResultHolder.success((Object)result.getResult());
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    private static boolean isMilkBucket(ItemStack stack) {
        return FluidHelper.getFluidFromStack((ItemStack)stack).getFluid() == NeoForgeMod.MILK.get();
    }

    private static class DispenserBehavior
    extends OptionalDispenseItemBehavior {
        private DispenserBehavior() {
        }

        protected ItemStack execute(BlockSource source, ItemStack stack) {
            ServerLevel level = source.level();
            Direction facing = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            BlockPos pos = source.pos().relative(facing);
            FluidActionResult action = FluidUtil.tryPickUpFluid((ItemStack)stack, null, (Level)level, (BlockPos)pos, (Direction)facing.getOpposite());
            ItemStack resultStack = action.getResult();
            if (!action.isSuccess() || resultStack.isEmpty()) {
                FluidActionResult result;
                ItemStack singleStack = StackHelper.withSize((ItemStack)stack, (int)1, (boolean)false);
                Optional fluidHandler = FluidUtil.getFluidHandler((ItemStack)singleStack);
                if (fluidHandler.isEmpty()) {
                    return super.execute(source, stack);
                }
                FluidStack fluidStack = ((IFluidHandlerItem)fluidHandler.get()).drain(1000, IFluidHandler.FluidAction.EXECUTE);
                FluidActionResult fluidActionResult = result = !fluidStack.isEmpty() ? FluidUtil.tryPlaceFluid(null, (Level)level, (InteractionHand)InteractionHand.MAIN_HAND, (BlockPos)pos, (ItemStack)stack, (FluidStack)fluidStack) : FluidActionResult.FAILURE;
                if (result.isSuccess()) {
                    ItemStack drainedStack = result.getResult();
                    if (drainedStack.getCount() == 1) {
                        return drainedStack;
                    }
                    if (!drainedStack.isEmpty() && !source.blockEntity().insertItem(drainedStack).isEmpty()) {
                        this.dispense(source, drainedStack);
                    }
                    return StackHelper.shrink((ItemStack)drainedStack, (int)1, (boolean)false);
                }
                return this.dispense(source, stack);
            }
            if (stack.getCount() == 1) {
                return resultStack;
            }
            if (!source.blockEntity().insertItem(resultStack).isEmpty()) {
                this.dispense(source, resultStack);
            }
            return resultStack;
        }
    }
}

