/*
 * Decompiled with CFR 0.152.
 */
package net.eightyseven.enderpouch.procedures;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.eightyseven.enderpouch.init.EnderpouchModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber
public class EnderPouchRightclickedProcedure {
    public static final Set<UUID> PLAYERS_USING_ENDER_POUCH = new HashSet<UUID>();
    private static final RandomSource RANDOM = RandomSource.create();

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        EnderPouchRightclickedProcedure.execute(event, (Entity)event.getEntity());
    }

    public static void execute(Entity entity) {
        EnderPouchRightclickedProcedure.execute(null, entity);
    }

    private static void execute(@Nullable PlayerInteractEvent.RightClickItem event, Entity entity) {
        if (entity == null) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        InteractionHand hand = event != null ? event.getHand() : InteractionHand.MAIN_HAND;
        ItemStack itemInHand = player.getItemInHand(hand);
        if (itemInHand.getItem() == EnderpouchModItems.ENDER_POUCH.get()) {
            if (!player.level().isClientSide() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ServerLevel serverLevel = serverPlayer.serverLevel();
                int particleCount = 4 + RANDOM.nextInt(3);
                for (int i = 0; i < particleCount; ++i) {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.DRAGON_BREATH, player.getX() + (RANDOM.nextDouble() - 0.5) * 0.8, player.getY() + (RANDOM.nextDouble() - 0.5) * 0.4, player.getZ() + (RANDOM.nextDouble() - 0.5) * 0.8, 1, 0.0, 0.0, 0.0, 0.0);
                }
                serverPlayer.openMenu((MenuProvider)new SimpleMenuProvider((windowId, playerInventory, p) -> ChestMenu.threeRows((int)windowId, (Inventory)playerInventory, (Container)player.getEnderChestInventory()), (Component)Component.translatable((String)"container.enderchest")));
                PLAYERS_USING_ENDER_POUCH.add(serverPlayer.getUUID());
                BlockPos playerPos = serverPlayer.blockPosition();
                serverLevel.playSound(null, playerPos, SoundEvents.ENDER_EYE_LAUNCH, SoundSource.PLAYERS, 0.7f, 2.0f);
            }
            player.swing(hand, true);
            if (event != null) {
                event.setCanceled(true);
            }
        }
    }
}

