/*
 * Decompiled with CFR 0.152.
 */
package com.styenvy.egtools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class BlockVariantCycle {
    private final String familyName;
    private final List<Block> blocks;
    private final Map<Block, Integer> blockToIndex;
    private final int size;

    public BlockVariantCycle(String familyName, Block ... blocks) {
        this(familyName, Arrays.asList(blocks));
    }

    public BlockVariantCycle(String familyName, List<Block> blocks) {
        if (blocks == null || blocks.isEmpty()) {
            throw new IllegalArgumentException("Block cycle must contain at least one block");
        }
        this.familyName = familyName;
        this.blocks = new ArrayList<Block>(blocks);
        this.size = this.blocks.size();
        this.blockToIndex = new HashMap<Block, Integer>(this.size);
        for (int i = 0; i < this.size; ++i) {
            Block block = this.blocks.get(i);
            if (block == null) {
                throw new IllegalArgumentException("Block cycle cannot contain null blocks");
            }
            if (this.blockToIndex.containsKey(block)) {
                throw new IllegalArgumentException("Block cycle cannot contain duplicate blocks: " + String.valueOf(block));
            }
            this.blockToIndex.put(block, i);
        }
    }

    @Nullable
    public Block getNext(Block current) {
        Integer index = this.blockToIndex.get(current);
        if (index == null) {
            return null;
        }
        int nextIndex = (index + 1) % this.size;
        return this.blocks.get(nextIndex);
    }

    @Nullable
    public Block getPrevious(Block current) {
        Integer index = this.blockToIndex.get(current);
        if (index == null) {
            return null;
        }
        int prevIndex = (index - 1 + this.size) % this.size;
        return this.blocks.get(prevIndex);
    }

    public boolean contains(Block block) {
        return this.blockToIndex.containsKey(block);
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public List<Block> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        return "BlockVariantCycle{family='" + this.familyName + "', size=" + this.size + "}";
    }

    public static class Builder {
        private final String familyName;
        private final List<Block> blocks = new ArrayList<Block>();

        public Builder(String familyName) {
            this.familyName = familyName;
        }

        public Builder add(Block block) {
            if (block != null) {
                this.blocks.add(block);
            }
            return this;
        }

        public Builder addAll(Block ... blocks) {
            for (Block block : blocks) {
                this.add(block);
            }
            return this;
        }

        public Builder addAll(Collection<Block> blocks) {
            for (Block block : blocks) {
                this.add(block);
            }
            return this;
        }

        public BlockVariantCycle build() {
            return new BlockVariantCycle(this.familyName, this.blocks);
        }
    }
}

