/*
 * Decompiled with CFR 0.152.
 */
package com.styenvy.egtools;

import com.styenvy.egtools.BlockVariantCycle;
import com.styenvy.egtools.BlockVariantRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import org.jetbrains.annotations.NotNull;

public class ConstructionHammerItem
extends Item {
    public ConstructionHammerItem(Item.Properties properties) {
        super(properties);
    }

    public boolean canAttackBlock(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player) {
        if (!level.isClientSide) {
            this.cycleBlock(level, pos, player, player.isShiftKeyDown());
        }
        return false;
    }

    private void cycleBlock(Level level, BlockPos pos, Player player, boolean cycleBackward) {
        Block nextBlock;
        BlockVariantCycle cycle;
        BlockState currentState = level.getBlockState(pos);
        Block currentBlock = currentState.getBlock();
        if (currentBlock instanceof SlabBlock && currentState.getValue((Property)SlabBlock.TYPE) == SlabType.TOP) {
            BlockPos belowPos = pos.below();
            BlockState belowState = level.getBlockState(belowPos);
            if (belowState.isAir() && !cycleBackward) {
                BlockState bottomSlab = (BlockState)currentState.setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM);
                level.setBlock(belowPos, bottomSlab, 3);
                level.setBlock(pos, level.getBlockState(pos.above()).isAir() ? Blocks.AIR.defaultBlockState() : currentState, 3);
                return;
            }
            if (!belowState.isAir()) {
                return;
            }
        }
        if ((cycle = BlockVariantRegistry.getCycle(currentBlock)) == null) {
            return;
        }
        Block block = nextBlock = cycleBackward ? cycle.getPrevious(currentBlock) : cycle.getNext(currentBlock);
        if (nextBlock == null || nextBlock == currentBlock) {
            return;
        }
        BlockState newState = nextBlock.defaultBlockState();
        if (newState.getBlock() instanceof DoorBlock) {
            BlockPos abovePos = pos.above();
            BlockState aboveState = level.getBlockState(abovePos);
            if (aboveState.isAir() || aboveState.canBeReplaced()) {
                BlockState bottomHalf = (BlockState)newState.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
                bottomHalf = this.preserveCompatibleProperties(currentState, bottomHalf);
                BlockState topHalf = (BlockState)newState.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER);
                topHalf = this.preserveCompatibleProperties(currentState, topHalf);
                level.setBlock(pos, bottomHalf, 3);
                level.setBlock(abovePos, topHalf, 3);
                return;
            }
            return;
        }
        if (newState.hasProperty((Property)SlabBlock.TYPE)) {
            newState = (BlockState)newState.setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM);
        }
        newState = this.preserveCompatibleProperties(currentState, newState);
        level.setBlock(pos, newState, 3);
    }

    private BlockState preserveCompatibleProperties(BlockState oldState, BlockState newState) {
        for (Property property : oldState.getProperties()) {
            if (!newState.hasProperty(property)) continue;
            try {
                if (property == SlabBlock.TYPE) {
                    newState = (BlockState)newState.setValue((Property)SlabBlock.TYPE, (Comparable)SlabType.BOTTOM);
                    continue;
                }
                if (property == DoorBlock.HALF) continue;
                newState = this.copyProperty(oldState, newState, property);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return newState;
    }

    private <T extends Comparable<T>> BlockState copyProperty(BlockState source, BlockState target, Property<T> property) {
        return (BlockState)target.setValue(property, source.getValue(property));
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return true;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"item.egtools.construction_hammer.tooltip1"));
        tooltip.add((Component)Component.translatable((String)"item.egtools.construction_hammer.tooltip2"));
        tooltip.add((Component)Component.translatable((String)"item.egtools.construction_hammer.tooltip3"));
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        return 1;
    }

    public boolean isDamageable(@NotNull ItemStack stack) {
        return false;
    }

    public float getDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        return 0.0f;
    }
}

