/*
 * Decompiled with CFR 0.152.
 */
package com.styenvy.egtools;

import com.styenvy.egtools.PaintVariantRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="egtools")
public class PaintBrushItem
extends Item {
    private static final String NBT_PAINT_COLOR = "PaintColor";
    private static final String NBT_PAINT_USES = "PaintUses";
    public static final int MAX_PAINT_USES = 128;

    public PaintBrushItem(Item.Properties props) {
        super(props.stacksTo(1));
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return PaintBrushItem.getPaintUses(stack) > 0;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext ctx) {
        return InteractionResult.PASS;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        int uses = PaintBrushItem.getPaintUses(stack);
        if (uses > 0) {
            DyeColor color = PaintBrushItem.getPaintColor(stack);
            if (color != null) {
                tooltip.add((Component)Component.literal((String)("\u00a77Paint: " + PaintBrushItem.formatColorName(color))));
                tooltip.add((Component)Component.literal((String)("\u00a77Uses: " + uses + "/128")));
            }
        } else {
            tooltip.add((Component)Component.literal((String)"\u00a77No paint loaded"));
            tooltip.add((Component)Component.literal((String)"\u00a77Combine with paint bucket to charge"));
        }
        tooltip.add((Component)Component.literal((String)"\u00a78Left-click or Shift+Left-click to paint blocks"));
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock e) {
        BlockPos pos;
        Player player = e.getEntity();
        ItemStack heldMain = player.getMainHandItem();
        ItemStack heldOff = player.getOffhandItem();
        ItemStack brushStack = ItemStack.EMPTY;
        InteractionHand brushHand = null;
        if (heldMain.getItem() instanceof PaintBrushItem) {
            brushStack = heldMain;
            brushHand = InteractionHand.MAIN_HAND;
        } else if (heldOff.getItem() instanceof PaintBrushItem) {
            brushStack = heldOff;
            brushHand = InteractionHand.OFF_HAND;
        } else {
            return;
        }
        e.setCanceled(true);
        if (player.level().isClientSide) {
            return;
        }
        int uses = PaintBrushItem.getPaintUses(brushStack);
        if (uses <= 0) {
            player.displayClientMessage((Component)Component.literal((String)"\u00a7cBrush has no paint!"), true);
            return;
        }
        DyeColor color = PaintBrushItem.getPaintColor(brushStack);
        if (color == null) {
            return;
        }
        Level level = player.level();
        if (!PaintVariantRegistry.isPaintable(level.getBlockState(pos = PaintBrushItem.normalizeToBedHead(level, e.getPos())).getBlock())) {
            player.displayClientMessage((Component)Component.literal((String)"\u00a7cThis block cannot be painted"), true);
            return;
        }
        boolean painted = PaintVariantRegistry.paint(level, pos, color);
        if (!painted) {
            player.displayClientMessage((Component)Component.literal((String)"\u00a7eBlock is already this color"), true);
            return;
        }
        if (!player.getAbilities().instabuild) {
            PaintBrushItem.setPaintUses(brushStack, uses - 1);
            if (uses - 1 <= 0) {
                PaintBrushItem.clearPaint(brushStack);
            }
        }
        level.playSound(null, pos, SoundEvents.BRUSH_SAND_COMPLETED, SoundSource.PLAYERS, 0.8f, 1.1f);
        player.swing(brushHand, true);
    }

    public static void chargeBrush(ItemStack brush, DyeColor color, int addUses) {
        if (!(brush.getItem() instanceof PaintBrushItem)) {
            return;
        }
        DyeColor currentColor = PaintBrushItem.getPaintColor(brush);
        int currentUses = PaintBrushItem.getPaintUses(brush);
        if (currentColor != color && currentColor != null) {
            PaintBrushItem.setPaintColor(brush, color);
            PaintBrushItem.setPaintUses(brush, Math.min(addUses, 128));
        } else {
            PaintBrushItem.setPaintColor(brush, color);
            PaintBrushItem.setPaintUses(brush, Math.min(currentUses + addUses, 128));
        }
    }

    private static DyeColor getPaintColor(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return null;
        }
        CompoundTag tag = data.copyTag();
        if (!tag.contains(NBT_PAINT_COLOR)) {
            return null;
        }
        String colorName = tag.getString(NBT_PAINT_COLOR);
        try {
            return DyeColor.valueOf((String)colorName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static void setPaintColor(ItemStack stack, DyeColor color) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        CompoundTag tag = data == null ? new CompoundTag() : data.copyTag();
        tag.putString(NBT_PAINT_COLOR, color.name());
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    private static int getPaintUses(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return 0;
        }
        CompoundTag tag = data.copyTag();
        return tag.getInt(NBT_PAINT_USES);
    }

    private static void setPaintUses(ItemStack stack, int uses) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        CompoundTag tag = data == null ? new CompoundTag() : data.copyTag();
        tag.putInt(NBT_PAINT_USES, Math.max(0, uses));
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    private static void clearPaint(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data != null) {
            CompoundTag tag = data.copyTag();
            tag.remove(NBT_PAINT_COLOR);
            tag.remove(NBT_PAINT_USES);
            if (tag.isEmpty()) {
                stack.remove(DataComponents.CUSTOM_DATA);
            } else {
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            }
        }
    }

    private static String formatColorName(DyeColor color) {
        String name = color.name().toLowerCase().replace('_', ' ');
        String[] words = name.split(" ");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (!result.isEmpty()) {
                result.append(" ");
            }
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1));
        }
        return result.toString();
    }

    private static BlockPos normalizeToBedHead(Level level, BlockPos pos) {
        BedPart part;
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof BedBlock && (part = (BedPart)state.getValue((Property)BedBlock.PART)) == BedPart.FOOT) {
            return pos.relative((Direction)state.getValue((Property)BedBlock.FACING));
        }
        return pos;
    }
}

