/*
 * Decompiled with CFR 0.152.
 */
package com.styenvy.egtools;

import com.styenvy.egtools.EgToolsItems;
import com.styenvy.egtools.EgToolsRecipeSerializers;
import com.styenvy.egtools.PaintBrushItem;
import com.styenvy.egtools.PaintBucketItem;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PaintBrushRecipe
extends CustomRecipe {
    public PaintBrushRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level level) {
        ItemStack brush = ItemStack.EMPTY;
        ItemStack bucket = ItemStack.EMPTY;
        int itemCount = 0;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            ++itemCount;
            if (stack.getItem() instanceof PaintBrushItem) {
                if (!brush.isEmpty()) {
                    return false;
                }
                brush = stack;
                continue;
            }
            if (stack.getItem() instanceof PaintBucketItem) {
                if (!bucket.isEmpty()) {
                    return false;
                }
                bucket = stack;
                continue;
            }
            return false;
        }
        return itemCount == 2 && !brush.isEmpty() && !bucket.isEmpty();
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        ItemStack brush = ItemStack.EMPTY;
        ItemStack bucket = ItemStack.EMPTY;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.getItem() instanceof PaintBrushItem) {
                brush = stack.copy();
                continue;
            }
            if (!(stack.getItem() instanceof PaintBucketItem)) continue;
            bucket = stack;
        }
        if (brush.isEmpty() || bucket.isEmpty()) {
            return ItemStack.EMPTY;
        }
        PaintBucketItem bucketItem = (PaintBucketItem)bucket.getItem();
        PaintBrushItem.chargeBrush(brush, bucketItem.getColor(), 32);
        return brush;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingInput input) {
        NonNullList remaining = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (!(stack.getItem() instanceof PaintBucketItem)) continue;
            remaining.set(i, (Object)((Item)EgToolsItems.EMPTY_PAINT_BUCKET.get()).getDefaultInstance());
        }
        return remaining;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)EgToolsRecipeSerializers.PAINT_BRUSH_RECIPE.get();
    }
}

