/*
 * Decompiled with CFR 0.152.
 */
package com.styenvy.egtools;

import com.styenvy.egtools.EgToolsItems;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.NotNull;

public class PaintBucketItem
extends Item {
    public static final int MAX_PAINTS = 32;
    private static final String KEY_REMAINING = "egtools_paints_remaining";
    private final DyeColor color;

    public PaintBucketItem(Item.Properties props, DyeColor color) {
        super(props.stacksTo(64));
        this.color = color;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"item.egtools.paint_bucket.tooltip"));
        int remaining = PaintBucketItem.getRemaining(stack);
        tooltip.add((Component)Component.literal((String)("\u00a77Remaining: " + remaining + " / 32")));
    }

    public static void consumeOnePaint(ItemStack stack, Player player) {
        if (player != null && player.getAbilities().instabuild) {
            return;
        }
        int remaining = PaintBucketItem.getRemaining(stack);
        if (remaining <= 0) {
            PaintBucketItem.convertOneToEmpty(stack, player);
            return;
        }
        if (--remaining > 0) {
            PaintBucketItem.setRemaining(stack, remaining);
        } else {
            PaintBucketItem.convertOneToEmpty(stack, player);
        }
    }

    private static void convertOneToEmpty(ItemStack stack, Player player) {
        ItemStack empty;
        stack.shrink(1);
        if (player != null && !player.addItem(empty = ((Item)EgToolsItems.EMPTY_PAINT_BUCKET.get()).getDefaultInstance())) {
            player.drop(empty, true);
        }
    }

    private static int getRemaining(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return 32;
        }
        CompoundTag tag = data.copyTag();
        return tag.contains(KEY_REMAINING, 3) ? tag.getInt(KEY_REMAINING) : 32;
    }

    private static void setRemaining(ItemStack stack, int value) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        CompoundTag tag = data == null ? new CompoundTag() : data.copyTag();
        tag.putInt(KEY_REMAINING, Math.max(0, Math.min(32, value)));
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }
}

