/*
 * Decompiled with CFR 0.152.
 */
package com.styenvy.egtools;

import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public final class PaintVariantRegistry {
    private PaintVariantRegistry() {
    }

    public static boolean isPaintable(Block block) {
        return block instanceof BedBlock || block instanceof CandleBlock || block instanceof CandleCakeBlock || block instanceof BannerBlock || block instanceof WallBannerBlock || PaintVariantRegistry.isAnyWool(block) || PaintVariantRegistry.isAnyCarpet(block) || PaintVariantRegistry.isAnyTerracotta(block) || PaintVariantRegistry.isAnyGlazedTerracotta(block) || PaintVariantRegistry.isAnyStainedGlass(block) || PaintVariantRegistry.isAnyStainedGlassPane(block) || PaintVariantRegistry.isAnyConcrete(block) || PaintVariantRegistry.isAnyConcretePowder(block) || PaintVariantRegistry.isAnyShulkerBox(block);
    }

    public static boolean paint(Level level, BlockPos pos, DyeColor color) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof BedBlock) {
            Block newBed = PaintVariantRegistry.bedByColor(color);
            if (newBed == null || newBed == block) {
                return false;
            }
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            BedPart part = (BedPart)state.getValue((Property)BedBlock.PART);
            BlockState thisNew = (BlockState)((BlockState)PaintVariantRegistry.copyCommonProperties(state, newBed.defaultBlockState()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing)).setValue((Property)BedBlock.PART, (Comparable)part);
            level.setBlock(pos, thisNew, 11);
            BlockPos otherPos = part == BedPart.HEAD ? pos.relative(facing.getOpposite()) : pos.relative(facing);
            BlockState otherState = level.getBlockState(otherPos);
            if (otherState.getBlock() instanceof BedBlock) {
                BedPart otherPart = part == BedPart.HEAD ? BedPart.FOOT : BedPart.HEAD;
                BlockState otherNew = (BlockState)((BlockState)PaintVariantRegistry.copyCommonProperties(otherState, newBed.defaultBlockState()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)facing)).setValue((Property)BedBlock.PART, (Comparable)otherPart);
                level.setBlock(otherPos, otherNew, 11);
            }
            return true;
        }
        if (block instanceof CandleBlock) {
            Block newCandle = PaintVariantRegistry.candleByColor(color);
            if (newCandle == null || newCandle == block) {
                return false;
            }
            BlockState newState = PaintVariantRegistry.copyCommonProperties(state, newCandle.defaultBlockState());
            if (state.hasProperty((Property)CandleBlock.CANDLES) && newState.hasProperty((Property)CandleBlock.CANDLES)) {
                newState = (BlockState)newState.setValue((Property)CandleBlock.CANDLES, (Comparable)((Integer)state.getValue((Property)CandleBlock.CANDLES)));
            }
            if (state.hasProperty((Property)BlockStateProperties.LIT) && newState.hasProperty((Property)BlockStateProperties.LIT)) {
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.LIT, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.LIT)));
            }
            level.setBlock(pos, newState, 11);
            return true;
        }
        if (block instanceof CandleCakeBlock) {
            Block newCake = PaintVariantRegistry.candleCakeByColor(color);
            if (newCake == null || newCake == block) {
                return false;
            }
            BlockState newState = PaintVariantRegistry.copyCommonProperties(state, newCake.defaultBlockState());
            if (state.hasProperty((Property)BlockStateProperties.LIT) && newState.hasProperty((Property)BlockStateProperties.LIT)) {
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.LIT, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.LIT)));
            }
            level.setBlock(pos, newState, 11);
            return true;
        }
        if (PaintVariantRegistry.isAnyShulkerBox(block)) {
            ShulkerBoxBlockEntity s;
            Block target = PaintVariantRegistry.shulkerByColor(color);
            if (target == null || target == block) {
                return false;
            }
            BlockEntity be = level.getBlockEntity(pos);
            ShulkerBoxBlockEntity old = be instanceof ShulkerBoxBlockEntity ? (s = (ShulkerBoxBlockEntity)be) : null;
            Component customName = null;
            NonNullList saved = null;
            if (old != null) {
                customName = old.getCustomName();
                int size = old.getContainerSize();
                saved = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
                for (int i = 0; i < size; ++i) {
                    saved.set(i, (Object)old.getItem(i).copy());
                }
                old.clearContent();
            }
            BlockState newState = PaintVariantRegistry.copyCommonProperties(state, target.defaultBlockState());
            if (state.hasProperty((Property)BlockStateProperties.FACING) && newState.hasProperty((Property)BlockStateProperties.FACING)) {
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.FACING, (Comparable)((Direction)state.getValue((Property)BlockStateProperties.FACING)));
            }
            level.setBlock(pos, newState, 11);
            BlockEntity beNew = level.getBlockEntity(pos);
            if (beNew instanceof ShulkerBoxBlockEntity) {
                ShulkerBoxBlockEntity shulkerNew = (ShulkerBoxBlockEntity)beNew;
                if (customName != null) {
                    boolean named = false;
                    try {
                        Method m = shulkerNew.getClass().getMethod("setCustomName", Component.class);
                        m.invoke((Object)shulkerNew, customName);
                        named = true;
                    }
                    catch (Throwable ignore) {
                        CompoundTag tag = new CompoundTag();
                        tag.putString("CustomName", Component.Serializer.toJson((Component)customName, (HolderLookup.Provider)level.registryAccess()));
                        shulkerNew.loadWithComponents(tag, (HolderLookup.Provider)level.registryAccess());
                        named = true;
                    }
                    shulkerNew.setChanged();
                }
                if (saved != null) {
                    int size = Math.min(saved.size(), shulkerNew.getContainerSize());
                    for (int i = 0; i < size; ++i) {
                        shulkerNew.setItem(i, (ItemStack)saved.get(i));
                    }
                }
                shulkerNew.setChanged();
                level.sendBlockUpdated(pos, newState, newState, 3);
            }
            return true;
        }
        if (block instanceof BannerBlock) {
            Block newBanner = PaintVariantRegistry.standingBannerByColor(color);
            if (newBanner == null || newBanner == block) {
                return false;
            }
            BlockState newState = PaintVariantRegistry.copyCommonProperties(state, newBanner.defaultBlockState());
            if (state.hasProperty((Property)BlockStateProperties.ROTATION_16) && newState.hasProperty((Property)BlockStateProperties.ROTATION_16)) {
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)((Integer)state.getValue((Property)BlockStateProperties.ROTATION_16)));
            }
            level.setBlock(pos, newState, 11);
            return true;
        }
        if (block instanceof WallBannerBlock) {
            Block newBanner = PaintVariantRegistry.wallBannerByColor(color);
            if (newBanner == null || newBanner == block) {
                return false;
            }
            BlockState newState = PaintVariantRegistry.copyCommonProperties(state, newBanner.defaultBlockState());
            if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && newState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
            }
            level.setBlock(pos, newState, 11);
            return true;
        }
        if (PaintVariantRegistry.isAnyWool(block)) {
            Block newWool = PaintVariantRegistry.woolByColor(color);
            if (newWool == null || newWool == block) {
                return false;
            }
            level.setBlock(pos, PaintVariantRegistry.copyCommonProperties(state, newWool.defaultBlockState()), 11);
            return true;
        }
        if (PaintVariantRegistry.isAnyCarpet(block)) {
            Block newCarpet = PaintVariantRegistry.carpetByColor(color);
            if (newCarpet == null || newCarpet == block) {
                return false;
            }
            level.setBlock(pos, PaintVariantRegistry.copyCommonProperties(state, newCarpet.defaultBlockState()), 11);
            return true;
        }
        if (PaintVariantRegistry.isAnyTerracotta(block)) {
            Block stained = PaintVariantRegistry.terracottaByColor(color);
            if (stained == null || stained == block) {
                return false;
            }
            level.setBlock(pos, PaintVariantRegistry.copyCommonProperties(state, stained.defaultBlockState()), 11);
            return true;
        }
        if (PaintVariantRegistry.isAnyGlazedTerracotta(block)) {
            Block glazed = PaintVariantRegistry.glazedTerracottaByColor(color);
            if (glazed == null || glazed == block) {
                return false;
            }
            BlockState newState = PaintVariantRegistry.copyCommonProperties(state, glazed.defaultBlockState());
            if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && newState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                newState = (BlockState)newState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
            }
            level.setBlock(pos, newState, 11);
            return true;
        }
        if (PaintVariantRegistry.isAnyStainedGlass(block)) {
            Block glass = PaintVariantRegistry.stainedGlassByColor(color);
            if (glass == null || glass == block) {
                return false;
            }
            level.setBlock(pos, PaintVariantRegistry.copyCommonProperties(state, glass.defaultBlockState()), 11);
            return true;
        }
        if (PaintVariantRegistry.isAnyStainedGlassPane(block)) {
            Block pane = PaintVariantRegistry.stainedGlassPaneByColor(color);
            if (pane == null || pane == block) {
                return false;
            }
            level.setBlock(pos, PaintVariantRegistry.copyCommonProperties(state, pane.defaultBlockState()), 11);
            return true;
        }
        if (PaintVariantRegistry.isAnyConcrete(block)) {
            Block concrete = PaintVariantRegistry.concreteByColor(color);
            if (concrete == null || concrete == block) {
                return false;
            }
            level.setBlock(pos, PaintVariantRegistry.copyCommonProperties(state, concrete.defaultBlockState()), 11);
            return true;
        }
        if (PaintVariantRegistry.isAnyConcretePowder(block)) {
            Block powder = PaintVariantRegistry.concretePowderByColor(color);
            if (powder == null || powder == block) {
                return false;
            }
            level.setBlock(pos, PaintVariantRegistry.copyCommonProperties(state, powder.defaultBlockState()), 11);
            return true;
        }
        return false;
    }

    private static BlockState copyCommonProperties(BlockState from, BlockState to) {
        for (Property p : from.getProperties()) {
            if (!to.getProperties().contains(p)) continue;
            to = PaintVariantRegistry.setUnchecked(to, p, from.getValue(p));
        }
        return to;
    }

    private static <T extends Comparable<T>> BlockState setUnchecked(BlockState state, Property p, Comparable v) {
        return (BlockState)state.setValue(p, v);
    }

    private static boolean isAnyWool(Block b) {
        return b == Blocks.WHITE_WOOL || b == Blocks.LIGHT_GRAY_WOOL || b == Blocks.GRAY_WOOL || b == Blocks.BLACK_WOOL || b == Blocks.BROWN_WOOL || b == Blocks.RED_WOOL || b == Blocks.ORANGE_WOOL || b == Blocks.YELLOW_WOOL || b == Blocks.LIME_WOOL || b == Blocks.GREEN_WOOL || b == Blocks.CYAN_WOOL || b == Blocks.LIGHT_BLUE_WOOL || b == Blocks.BLUE_WOOL || b == Blocks.PURPLE_WOOL || b == Blocks.MAGENTA_WOOL || b == Blocks.PINK_WOOL;
    }

    private static boolean isAnyCarpet(Block b) {
        return b == Blocks.WHITE_CARPET || b == Blocks.LIGHT_GRAY_CARPET || b == Blocks.GRAY_CARPET || b == Blocks.BLACK_CARPET || b == Blocks.BROWN_CARPET || b == Blocks.RED_CARPET || b == Blocks.ORANGE_CARPET || b == Blocks.YELLOW_CARPET || b == Blocks.LIME_CARPET || b == Blocks.GREEN_CARPET || b == Blocks.CYAN_CARPET || b == Blocks.LIGHT_BLUE_CARPET || b == Blocks.BLUE_CARPET || b == Blocks.PURPLE_CARPET || b == Blocks.MAGENTA_CARPET || b == Blocks.PINK_CARPET;
    }

    private static boolean isAnyTerracotta(Block b) {
        return b == Blocks.WHITE_TERRACOTTA || b == Blocks.LIGHT_GRAY_TERRACOTTA || b == Blocks.GRAY_TERRACOTTA || b == Blocks.BLACK_TERRACOTTA || b == Blocks.BROWN_TERRACOTTA || b == Blocks.RED_TERRACOTTA || b == Blocks.ORANGE_TERRACOTTA || b == Blocks.YELLOW_TERRACOTTA || b == Blocks.LIME_TERRACOTTA || b == Blocks.GREEN_TERRACOTTA || b == Blocks.CYAN_TERRACOTTA || b == Blocks.LIGHT_BLUE_TERRACOTTA || b == Blocks.BLUE_TERRACOTTA || b == Blocks.PURPLE_TERRACOTTA || b == Blocks.MAGENTA_TERRACOTTA || b == Blocks.PINK_TERRACOTTA;
    }

    private static boolean isAnyShulkerBox(Block b) {
        return b == Blocks.SHULKER_BOX || b == Blocks.WHITE_SHULKER_BOX || b == Blocks.LIGHT_GRAY_SHULKER_BOX || b == Blocks.GRAY_SHULKER_BOX || b == Blocks.BLACK_SHULKER_BOX || b == Blocks.BROWN_SHULKER_BOX || b == Blocks.RED_SHULKER_BOX || b == Blocks.ORANGE_SHULKER_BOX || b == Blocks.YELLOW_SHULKER_BOX || b == Blocks.LIME_SHULKER_BOX || b == Blocks.GREEN_SHULKER_BOX || b == Blocks.CYAN_SHULKER_BOX || b == Blocks.LIGHT_BLUE_SHULKER_BOX || b == Blocks.BLUE_SHULKER_BOX || b == Blocks.PURPLE_SHULKER_BOX || b == Blocks.MAGENTA_SHULKER_BOX || b == Blocks.PINK_SHULKER_BOX;
    }

    private static boolean isAnyGlazedTerracotta(Block b) {
        return b == Blocks.WHITE_GLAZED_TERRACOTTA || b == Blocks.LIGHT_GRAY_GLAZED_TERRACOTTA || b == Blocks.GRAY_GLAZED_TERRACOTTA || b == Blocks.BLACK_GLAZED_TERRACOTTA || b == Blocks.BROWN_GLAZED_TERRACOTTA || b == Blocks.RED_GLAZED_TERRACOTTA || b == Blocks.ORANGE_GLAZED_TERRACOTTA || b == Blocks.YELLOW_GLAZED_TERRACOTTA || b == Blocks.LIME_GLAZED_TERRACOTTA || b == Blocks.GREEN_GLAZED_TERRACOTTA || b == Blocks.CYAN_GLAZED_TERRACOTTA || b == Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA || b == Blocks.BLUE_GLAZED_TERRACOTTA || b == Blocks.PURPLE_GLAZED_TERRACOTTA || b == Blocks.MAGENTA_GLAZED_TERRACOTTA || b == Blocks.PINK_GLAZED_TERRACOTTA;
    }

    private static boolean isAnyStainedGlass(Block b) {
        return b == Blocks.WHITE_STAINED_GLASS || b == Blocks.LIGHT_GRAY_STAINED_GLASS || b == Blocks.GRAY_STAINED_GLASS || b == Blocks.BLACK_STAINED_GLASS || b == Blocks.BROWN_STAINED_GLASS || b == Blocks.RED_STAINED_GLASS || b == Blocks.ORANGE_STAINED_GLASS || b == Blocks.YELLOW_STAINED_GLASS || b == Blocks.LIME_STAINED_GLASS || b == Blocks.GREEN_STAINED_GLASS || b == Blocks.CYAN_STAINED_GLASS || b == Blocks.LIGHT_BLUE_STAINED_GLASS || b == Blocks.BLUE_STAINED_GLASS || b == Blocks.PURPLE_STAINED_GLASS || b == Blocks.MAGENTA_STAINED_GLASS || b == Blocks.PINK_STAINED_GLASS;
    }

    private static boolean isAnyStainedGlassPane(Block b) {
        return b == Blocks.WHITE_STAINED_GLASS_PANE || b == Blocks.LIGHT_GRAY_STAINED_GLASS_PANE || b == Blocks.GRAY_STAINED_GLASS_PANE || b == Blocks.BLACK_STAINED_GLASS_PANE || b == Blocks.BROWN_STAINED_GLASS_PANE || b == Blocks.RED_STAINED_GLASS_PANE || b == Blocks.ORANGE_STAINED_GLASS_PANE || b == Blocks.YELLOW_STAINED_GLASS_PANE || b == Blocks.LIME_STAINED_GLASS_PANE || b == Blocks.GREEN_STAINED_GLASS_PANE || b == Blocks.CYAN_STAINED_GLASS_PANE || b == Blocks.LIGHT_BLUE_STAINED_GLASS_PANE || b == Blocks.BLUE_STAINED_GLASS_PANE || b == Blocks.PURPLE_STAINED_GLASS_PANE || b == Blocks.MAGENTA_STAINED_GLASS_PANE || b == Blocks.PINK_STAINED_GLASS_PANE;
    }

    private static boolean isAnyConcrete(Block b) {
        return b == Blocks.WHITE_CONCRETE || b == Blocks.LIGHT_GRAY_CONCRETE || b == Blocks.GRAY_CONCRETE || b == Blocks.BLACK_CONCRETE || b == Blocks.BROWN_CONCRETE || b == Blocks.RED_CONCRETE || b == Blocks.ORANGE_CONCRETE || b == Blocks.YELLOW_CONCRETE || b == Blocks.LIME_CONCRETE || b == Blocks.GREEN_CONCRETE || b == Blocks.CYAN_CONCRETE || b == Blocks.LIGHT_BLUE_CONCRETE || b == Blocks.BLUE_CONCRETE || b == Blocks.PURPLE_CONCRETE || b == Blocks.MAGENTA_CONCRETE || b == Blocks.PINK_CONCRETE;
    }

    private static boolean isAnyConcretePowder(Block b) {
        return b == Blocks.WHITE_CONCRETE_POWDER || b == Blocks.LIGHT_GRAY_CONCRETE_POWDER || b == Blocks.GRAY_CONCRETE_POWDER || b == Blocks.BLACK_CONCRETE_POWDER || b == Blocks.BROWN_CONCRETE_POWDER || b == Blocks.RED_CONCRETE_POWDER || b == Blocks.ORANGE_CONCRETE_POWDER || b == Blocks.YELLOW_CONCRETE_POWDER || b == Blocks.LIME_CONCRETE_POWDER || b == Blocks.GREEN_CONCRETE_POWDER || b == Blocks.CYAN_CONCRETE_POWDER || b == Blocks.LIGHT_BLUE_CONCRETE_POWDER || b == Blocks.BLUE_CONCRETE_POWDER || b == Blocks.PURPLE_CONCRETE_POWDER || b == Blocks.MAGENTA_CONCRETE_POWDER || b == Blocks.PINK_CONCRETE_POWDER;
    }

    private static Block woolByColor(DyeColor c) {
        return switch (c) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_WOOL;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_WOOL;
            case DyeColor.GRAY -> Blocks.GRAY_WOOL;
            case DyeColor.BLACK -> Blocks.BLACK_WOOL;
            case DyeColor.BROWN -> Blocks.BROWN_WOOL;
            case DyeColor.RED -> Blocks.RED_WOOL;
            case DyeColor.ORANGE -> Blocks.ORANGE_WOOL;
            case DyeColor.YELLOW -> Blocks.YELLOW_WOOL;
            case DyeColor.LIME -> Blocks.LIME_WOOL;
            case DyeColor.GREEN -> Blocks.GREEN_WOOL;
            case DyeColor.CYAN -> Blocks.CYAN_WOOL;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_WOOL;
            case DyeColor.BLUE -> Blocks.BLUE_WOOL;
            case DyeColor.PURPLE -> Blocks.PURPLE_WOOL;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_WOOL;
            case DyeColor.PINK -> Blocks.PINK_WOOL;
        };
    }

    private static Block carpetByColor(DyeColor c) {
        return switch (c) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_CARPET;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_CARPET;
            case DyeColor.GRAY -> Blocks.GRAY_CARPET;
            case DyeColor.BLACK -> Blocks.BLACK_CARPET;
            case DyeColor.BROWN -> Blocks.BROWN_CARPET;
            case DyeColor.RED -> Blocks.RED_CARPET;
            case DyeColor.ORANGE -> Blocks.ORANGE_CARPET;
            case DyeColor.YELLOW -> Blocks.YELLOW_CARPET;
            case DyeColor.LIME -> Blocks.LIME_CARPET;
            case DyeColor.GREEN -> Blocks.GREEN_CARPET;
            case DyeColor.CYAN -> Blocks.CYAN_CARPET;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_CARPET;
            case DyeColor.BLUE -> Blocks.BLUE_CARPET;
            case DyeColor.PURPLE -> Blocks.PURPLE_CARPET;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_CARPET;
            case DyeColor.PINK -> Blocks.PINK_CARPET;
        };
    }

    private static Block terracottaByColor(DyeColor c) {
        return switch (c) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_TERRACOTTA;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_TERRACOTTA;
            case DyeColor.GRAY -> Blocks.GRAY_TERRACOTTA;
            case DyeColor.BLACK -> Blocks.BLACK_TERRACOTTA;
            case DyeColor.BROWN -> Blocks.BROWN_TERRACOTTA;
            case DyeColor.RED -> Blocks.RED_TERRACOTTA;
            case DyeColor.ORANGE -> Blocks.ORANGE_TERRACOTTA;
            case DyeColor.YELLOW -> Blocks.YELLOW_TERRACOTTA;
            case DyeColor.LIME -> Blocks.LIME_TERRACOTTA;
            case DyeColor.GREEN -> Blocks.GREEN_TERRACOTTA;
            case DyeColor.CYAN -> Blocks.CYAN_TERRACOTTA;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_TERRACOTTA;
            case DyeColor.BLUE -> Blocks.BLUE_TERRACOTTA;
            case DyeColor.PURPLE -> Blocks.PURPLE_TERRACOTTA;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_TERRACOTTA;
            case DyeColor.PINK -> Blocks.PINK_TERRACOTTA;
        };
    }

    private static Block shulkerByColor(DyeColor c) {
        return switch (c) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_SHULKER_BOX;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_SHULKER_BOX;
            case DyeColor.GRAY -> Blocks.GRAY_SHULKER_BOX;
            case DyeColor.BLACK -> Blocks.BLACK_SHULKER_BOX;
            case DyeColor.BROWN -> Blocks.BROWN_SHULKER_BOX;
            case DyeColor.RED -> Blocks.RED_SHULKER_BOX;
            case DyeColor.ORANGE -> Blocks.ORANGE_SHULKER_BOX;
            case DyeColor.YELLOW -> Blocks.YELLOW_SHULKER_BOX;
            case DyeColor.LIME -> Blocks.LIME_SHULKER_BOX;
            case DyeColor.GREEN -> Blocks.GREEN_SHULKER_BOX;
            case DyeColor.CYAN -> Blocks.CYAN_SHULKER_BOX;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_SHULKER_BOX;
            case DyeColor.BLUE -> Blocks.BLUE_SHULKER_BOX;
            case DyeColor.PURPLE -> Blocks.PURPLE_SHULKER_BOX;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_SHULKER_BOX;
            case DyeColor.PINK -> Blocks.PINK_SHULKER_BOX;
        };
    }

    private static Block glazedTerracottaByColor(DyeColor c) {
        return switch (c) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_GLAZED_TERRACOTTA;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_GLAZED_TERRACOTTA;
            case DyeColor.GRAY -> Blocks.GRAY_GLAZED_TERRACOTTA;
            case DyeColor.BLACK -> Blocks.BLACK_GLAZED_TERRACOTTA;
            case DyeColor.BROWN -> Blocks.BROWN_GLAZED_TERRACOTTA;
            case DyeColor.RED -> Blocks.RED_GLAZED_TERRACOTTA;
            case DyeColor.ORANGE -> Blocks.ORANGE_GLAZED_TERRACOTTA;
            case DyeColor.YELLOW -> Blocks.YELLOW_GLAZED_TERRACOTTA;
            case DyeColor.LIME -> Blocks.LIME_GLAZED_TERRACOTTA;
            case DyeColor.GREEN -> Blocks.GREEN_GLAZED_TERRACOTTA;
            case DyeColor.CYAN -> Blocks.CYAN_GLAZED_TERRACOTTA;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_GLAZED_TERRACOTTA;
            case DyeColor.BLUE -> Blocks.BLUE_GLAZED_TERRACOTTA;
            case DyeColor.PURPLE -> Blocks.PURPLE_GLAZED_TERRACOTTA;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_GLAZED_TERRACOTTA;
            case DyeColor.PINK -> Blocks.PINK_GLAZED_TERRACOTTA;
        };
    }

    private static Block stainedGlassByColor(DyeColor c) {
        return switch (c) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_STAINED_GLASS;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_STAINED_GLASS;
            case DyeColor.GRAY -> Blocks.GRAY_STAINED_GLASS;
            case DyeColor.BLACK -> Blocks.BLACK_STAINED_GLASS;
            case DyeColor.BROWN -> Blocks.BROWN_STAINED_GLASS;
            case DyeColor.RED -> Blocks.RED_STAINED_GLASS;
            case DyeColor.ORANGE -> Blocks.ORANGE_STAINED_GLASS;
            case DyeColor.YELLOW -> Blocks.YELLOW_STAINED_GLASS;
            case DyeColor.LIME -> Blocks.LIME_STAINED_GLASS;
            case DyeColor.GREEN -> Blocks.GREEN_STAINED_GLASS;
            case DyeColor.CYAN -> Blocks.CYAN_STAINED_GLASS;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_STAINED_GLASS;
            case DyeColor.BLUE -> Blocks.BLUE_STAINED_GLASS;
            case DyeColor.PURPLE -> Blocks.PURPLE_STAINED_GLASS;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_STAINED_GLASS;
            case DyeColor.PINK -> Blocks.PINK_STAINED_GLASS;
        };
    }

    private static Block stainedGlassPaneByColor(DyeColor c) {
        return switch (c) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_STAINED_GLASS_PANE;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_STAINED_GLASS_PANE;
            case DyeColor.GRAY -> Blocks.GRAY_STAINED_GLASS_PANE;
            case DyeColor.BLACK -> Blocks.BLACK_STAINED_GLASS_PANE;
            case DyeColor.BROWN -> Blocks.BROWN_STAINED_GLASS_PANE;
            case DyeColor.RED -> Blocks.RED_STAINED_GLASS_PANE;
            case DyeColor.ORANGE -> Blocks.ORANGE_STAINED_GLASS_PANE;
            case DyeColor.YELLOW -> Blocks.YELLOW_STAINED_GLASS_PANE;
            case DyeColor.LIME -> Blocks.LIME_STAINED_GLASS_PANE;
            case DyeColor.GREEN -> Blocks.GREEN_STAINED_GLASS_PANE;
            case DyeColor.CYAN -> Blocks.CYAN_STAINED_GLASS_PANE;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_STAINED_GLASS_PANE;
            case DyeColor.BLUE -> Blocks.BLUE_STAINED_GLASS_PANE;
            case DyeColor.PURPLE -> Blocks.PURPLE_STAINED_GLASS_PANE;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_STAINED_GLASS_PANE;
            case DyeColor.PINK -> Blocks.PINK_STAINED_GLASS_PANE;
        };
    }

    private static Block concreteByColor(DyeColor c) {
        return switch (c) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_CONCRETE;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_CONCRETE;
            case DyeColor.GRAY -> Blocks.GRAY_CONCRETE;
            case DyeColor.BLACK -> Blocks.BLACK_CONCRETE;
            case DyeColor.BROWN -> Blocks.BROWN_CONCRETE;
            case DyeColor.RED -> Blocks.RED_CONCRETE;
            case DyeColor.ORANGE -> Blocks.ORANGE_CONCRETE;
            case DyeColor.YELLOW -> Blocks.YELLOW_CONCRETE;
            case DyeColor.LIME -> Blocks.LIME_CONCRETE;
            case DyeColor.GREEN -> Blocks.GREEN_CONCRETE;
            case DyeColor.CYAN -> Blocks.CYAN_CONCRETE;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_CONCRETE;
            case DyeColor.BLUE -> Blocks.BLUE_CONCRETE;
            case DyeColor.PURPLE -> Blocks.PURPLE_CONCRETE;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_CONCRETE;
            case DyeColor.PINK -> Blocks.PINK_CONCRETE;
        };
    }

    private static Block concretePowderByColor(DyeColor c) {
        return switch (c) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_CONCRETE_POWDER;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_CONCRETE_POWDER;
            case DyeColor.GRAY -> Blocks.GRAY_CONCRETE_POWDER;
            case DyeColor.BLACK -> Blocks.BLACK_CONCRETE_POWDER;
            case DyeColor.BROWN -> Blocks.BROWN_CONCRETE_POWDER;
            case DyeColor.RED -> Blocks.RED_CONCRETE_POWDER;
            case DyeColor.ORANGE -> Blocks.ORANGE_CONCRETE_POWDER;
            case DyeColor.YELLOW -> Blocks.YELLOW_CONCRETE_POWDER;
            case DyeColor.LIME -> Blocks.LIME_CONCRETE_POWDER;
            case DyeColor.GREEN -> Blocks.GREEN_CONCRETE_POWDER;
            case DyeColor.CYAN -> Blocks.CYAN_CONCRETE_POWDER;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_CONCRETE_POWDER;
            case DyeColor.BLUE -> Blocks.BLUE_CONCRETE_POWDER;
            case DyeColor.PURPLE -> Blocks.PURPLE_CONCRETE_POWDER;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_CONCRETE_POWDER;
            case DyeColor.PINK -> Blocks.PINK_CONCRETE_POWDER;
        };
    }

    private static Block bedByColor(DyeColor c) {
        return switch (c) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_BED;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_BED;
            case DyeColor.GRAY -> Blocks.GRAY_BED;
            case DyeColor.BLACK -> Blocks.BLACK_BED;
            case DyeColor.BROWN -> Blocks.BROWN_BED;
            case DyeColor.RED -> Blocks.RED_BED;
            case DyeColor.ORANGE -> Blocks.ORANGE_BED;
            case DyeColor.YELLOW -> Blocks.YELLOW_BED;
            case DyeColor.LIME -> Blocks.LIME_BED;
            case DyeColor.GREEN -> Blocks.GREEN_BED;
            case DyeColor.CYAN -> Blocks.CYAN_BED;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_BED;
            case DyeColor.BLUE -> Blocks.BLUE_BED;
            case DyeColor.PURPLE -> Blocks.PURPLE_BED;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_BED;
            case DyeColor.PINK -> Blocks.PINK_BED;
        };
    }

    private static Block candleByColor(DyeColor c) {
        return switch (c) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_CANDLE;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_CANDLE;
            case DyeColor.GRAY -> Blocks.GRAY_CANDLE;
            case DyeColor.BLACK -> Blocks.BLACK_CANDLE;
            case DyeColor.BROWN -> Blocks.BROWN_CANDLE;
            case DyeColor.RED -> Blocks.RED_CANDLE;
            case DyeColor.ORANGE -> Blocks.ORANGE_CANDLE;
            case DyeColor.YELLOW -> Blocks.YELLOW_CANDLE;
            case DyeColor.LIME -> Blocks.LIME_CANDLE;
            case DyeColor.GREEN -> Blocks.GREEN_CANDLE;
            case DyeColor.CYAN -> Blocks.CYAN_CANDLE;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_CANDLE;
            case DyeColor.BLUE -> Blocks.BLUE_CANDLE;
            case DyeColor.PURPLE -> Blocks.PURPLE_CANDLE;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_CANDLE;
            case DyeColor.PINK -> Blocks.PINK_CANDLE;
        };
    }

    private static Block candleCakeByColor(DyeColor c) {
        return switch (c) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_CANDLE_CAKE;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_CANDLE_CAKE;
            case DyeColor.GRAY -> Blocks.GRAY_CANDLE_CAKE;
            case DyeColor.BLACK -> Blocks.BLACK_CANDLE_CAKE;
            case DyeColor.BROWN -> Blocks.BROWN_CANDLE_CAKE;
            case DyeColor.RED -> Blocks.RED_CANDLE_CAKE;
            case DyeColor.ORANGE -> Blocks.ORANGE_CANDLE_CAKE;
            case DyeColor.YELLOW -> Blocks.YELLOW_CANDLE_CAKE;
            case DyeColor.LIME -> Blocks.LIME_CANDLE_CAKE;
            case DyeColor.GREEN -> Blocks.GREEN_CANDLE_CAKE;
            case DyeColor.CYAN -> Blocks.CYAN_CANDLE_CAKE;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_CANDLE_CAKE;
            case DyeColor.BLUE -> Blocks.BLUE_CANDLE_CAKE;
            case DyeColor.PURPLE -> Blocks.PURPLE_CANDLE_CAKE;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_CANDLE_CAKE;
            case DyeColor.PINK -> Blocks.PINK_CANDLE_CAKE;
        };
    }

    private static Block standingBannerByColor(DyeColor c) {
        return switch (c) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_BANNER;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_BANNER;
            case DyeColor.GRAY -> Blocks.GRAY_BANNER;
            case DyeColor.BLACK -> Blocks.BLACK_BANNER;
            case DyeColor.BROWN -> Blocks.BROWN_BANNER;
            case DyeColor.RED -> Blocks.RED_BANNER;
            case DyeColor.ORANGE -> Blocks.ORANGE_BANNER;
            case DyeColor.YELLOW -> Blocks.YELLOW_BANNER;
            case DyeColor.LIME -> Blocks.LIME_BANNER;
            case DyeColor.GREEN -> Blocks.GREEN_BANNER;
            case DyeColor.CYAN -> Blocks.CYAN_BANNER;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_BANNER;
            case DyeColor.BLUE -> Blocks.BLUE_BANNER;
            case DyeColor.PURPLE -> Blocks.PURPLE_BANNER;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_BANNER;
            case DyeColor.PINK -> Blocks.PINK_BANNER;
        };
    }

    private static Block wallBannerByColor(DyeColor c) {
        return switch (c) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Blocks.WHITE_WALL_BANNER;
            case DyeColor.LIGHT_GRAY -> Blocks.LIGHT_GRAY_WALL_BANNER;
            case DyeColor.GRAY -> Blocks.GRAY_WALL_BANNER;
            case DyeColor.BLACK -> Blocks.BLACK_WALL_BANNER;
            case DyeColor.BROWN -> Blocks.BROWN_WALL_BANNER;
            case DyeColor.RED -> Blocks.RED_WALL_BANNER;
            case DyeColor.ORANGE -> Blocks.ORANGE_WALL_BANNER;
            case DyeColor.YELLOW -> Blocks.YELLOW_WALL_BANNER;
            case DyeColor.LIME -> Blocks.LIME_WALL_BANNER;
            case DyeColor.GREEN -> Blocks.GREEN_WALL_BANNER;
            case DyeColor.CYAN -> Blocks.CYAN_WALL_BANNER;
            case DyeColor.LIGHT_BLUE -> Blocks.LIGHT_BLUE_WALL_BANNER;
            case DyeColor.BLUE -> Blocks.BLUE_WALL_BANNER;
            case DyeColor.PURPLE -> Blocks.PURPLE_WALL_BANNER;
            case DyeColor.MAGENTA -> Blocks.MAGENTA_WALL_BANNER;
            case DyeColor.PINK -> Blocks.PINK_WALL_BANNER;
        };
    }
}

