/*
 * Decompiled with CFR 0.152.
 */
package com.styenvy.egtools;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.extensions.IItemExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaxelItem
extends Item
implements IItemExtension {
    private static final int DURABILITY_MULT = 6;
    private static final float SPEED_MULT = 1.1f;
    private static final float BASE_SWORD_DMG = 4.0f;
    private static final float ATTACK_SPEED = -2.6f;
    private final Tier tier;

    public PaxelItem(Tier tier, Item.Properties props) {
        super(props.durability(Math.max(1, tier.getUses() * 6)).attributes(PaxelItem.createAttributes(tier)));
        this.tier = tier;
    }

    public boolean canPerformAction(@NotNull ItemStack stack, @NotNull ItemAbility ability) {
        if (stack.isDamaged() && stack.getDamageValue() >= stack.getMaxDamage()) {
            return false;
        }
        return ability == ItemAbilities.PICKAXE_DIG || ability == ItemAbilities.AXE_DIG || ability == ItemAbilities.AXE_STRIP || ability == ItemAbilities.AXE_SCRAPE || ability == ItemAbilities.AXE_WAX_OFF || ability == ItemAbilities.SHOVEL_DIG || ability == ItemAbilities.SHOVEL_FLATTEN || ability == ItemAbilities.HOE_TILL || ability == ItemAbilities.SWORD_DIG || ability == ItemAbilities.SWORD_SWEEP || ability == ItemAbilities.SHEARS_DIG || ability == ItemAbilities.SHEARS_CARVE || ability == ItemAbilities.SHEARS_DISARM || ability == ItemAbilities.SHEARS_HARVEST;
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext ctx) {
        Player player;
        ItemStack stack;
        BlockPos pos;
        Level level = ctx.getLevel();
        BlockState state = level.getBlockState(pos = ctx.getClickedPos());
        if (PaxelItem.tryModify(state, ctx, ItemAbilities.AXE_STRIP, SoundEvents.AXE_STRIP, level, pos, stack = ctx.getItemInHand(), player = ctx.getPlayer(), 0)) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (PaxelItem.tryModify(state, ctx, ItemAbilities.AXE_SCRAPE, SoundEvents.AXE_SCRAPE, level, pos, stack, player, 3005)) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (PaxelItem.tryModify(state, ctx, ItemAbilities.AXE_WAX_OFF, SoundEvents.AXE_WAX_OFF, level, pos, stack, player, 3004)) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (PaxelItem.tryModify(state, ctx, ItemAbilities.SHOVEL_FLATTEN, SoundEvents.SHOVEL_FLATTEN, level, pos, stack, player, 0)) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (PaxelItem.tryModify(state, ctx, ItemAbilities.HOE_TILL, SoundEvents.HOE_TILL, level, pos, stack, player, 0)) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (PaxelItem.tryModify(state, ctx, ItemAbilities.SHEARS_CARVE, SoundEvents.PUMPKIN_CARVE, level, pos, stack, player, 0)) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (PaxelItem.tryModify(state, ctx, ItemAbilities.SHEARS_DISARM, null, level, pos, stack, player, 0)) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (PaxelItem.tryModify(state, ctx, ItemAbilities.SHEARS_HARVEST, SoundEvents.BEEHIVE_SHEAR, level, pos, stack, player, 0)) {
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public float getDestroySpeed(@NotNull ItemStack stack, BlockState state) {
        if (state.is(BlockTags.MINEABLE_WITH_PICKAXE) || state.is(BlockTags.MINEABLE_WITH_AXE) || state.is(BlockTags.MINEABLE_WITH_SHOVEL) || state.is(BlockTags.MINEABLE_WITH_HOE) || state.is(BlockTags.LEAVES) || state.is(BlockTags.WOOL) || state.is(BlockTags.SWORD_EFFICIENT)) {
            return this.tier.getSpeed() * 1.1f;
        }
        return 1.0f;
    }

    public boolean isCorrectToolForDrops(@NotNull ItemStack stack, BlockState state) {
        if (state.is(this.tier.getIncorrectBlocksForDrops())) {
            return false;
        }
        return state.is(BlockTags.MINEABLE_WITH_PICKAXE) || state.is(BlockTags.MINEABLE_WITH_AXE) || state.is(BlockTags.MINEABLE_WITH_SHOVEL) || state.is(BlockTags.MINEABLE_WITH_HOE);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        return Items.SHEARS.interactLivingEntity(stack, player, target, hand);
    }

    public int getEnchantmentValue(@NotNull ItemStack stack) {
        return this.tier.getEnchantmentValue();
    }

    public boolean isValidRepairItem(@NotNull ItemStack toRepair, @NotNull ItemStack repairCandidate) {
        return this.tier.getRepairIngredient().test(repairCandidate);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"item.egtools.paxel.tooltip1"));
        tooltip.add((Component)Component.translatable((String)"item.egtools.paxel.tooltip2"));
        tooltip.add((Component)Component.translatable((String)"item.egtools.paxel.tooltip3"));
    }

    private static ItemAttributeModifiers createAttributes(Tier tier) {
        double damage = 4.0f + tier.getAttackDamageBonus();
        AttributeModifier modDamage = new AttributeModifier(BASE_ATTACK_DAMAGE_ID, damage, AttributeModifier.Operation.ADD_VALUE);
        AttributeModifier modSpeed = new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)-2.6f, AttributeModifier.Operation.ADD_VALUE);
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, modDamage, EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, modSpeed, EquipmentSlotGroup.MAINHAND).build();
    }

    private static boolean tryModify(BlockState state, UseOnContext ctx, ItemAbility ability, @Nullable SoundEvent sound, Level level, BlockPos pos, ItemStack stack, @Nullable Player player, int levelEvent) {
        BlockState modified = state.getToolModifiedState(ctx, ability, false);
        if (modified == null) {
            return false;
        }
        if (sound != null) {
            level.playSound(player, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (levelEvent != 0) {
            level.levelEvent(player, levelEvent, pos, 0);
        }
        level.setBlock(pos, modified, 11);
        if (player != null) {
            EquipmentSlot slot = ctx.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            stack.hurtAndBreak(1, (LivingEntity)player, slot);
        }
        return true;
    }
}

