/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.platform;

import java.util.Collection;
import java.util.Optional;
import me.shedaniel.autoconfig.ConfigData;
import me.villagerunknown.platform.util.ConfigUtil;
import me.villagerunknown.platform.util.PlatformUtil;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.Person;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformMod<T extends ConfigData> {
    private String MOD_ID = null;
    private Logger LOGGER = null;
    private T CONFIG = null;

    public PlatformMod(String modId, Class<?> loggerClass, Class<T> configClass) {
        this.MOD_ID = PlatformUtil.formModId(modId);
        this.LOGGER = LoggerFactory.getLogger(loggerClass);
        this.CONFIG = ConfigUtil.registerConfig(configClass);
    }

    public String getModId() {
        return this.MOD_ID;
    }

    public String getModIdVersion() {
        return this.MOD_ID + "-" + this.getVersion();
    }

    public Logger getLogger() {
        return this.LOGGER;
    }

    public T getConfig() {
        return this.CONFIG;
    }

    public Optional<ModContainer> getContainer() {
        return FabricLoader.getInstance().getModContainer(this.MOD_ID);
    }

    public String getVersion() {
        return this.getContainer().map(modContainer -> modContainer.getMetadata().getVersion().getFriendlyString()).orElse("0.0.0");
    }

    public String getName() {
        return this.getContainer().map(modContainer -> modContainer.getMetadata().getName()).orElse("[Missing Name]");
    }

    public String getDescription() {
        return this.getContainer().map(modContainer -> modContainer.getMetadata().getDescription()).orElse("[Missing Description]");
    }

    public Optional<Collection<Person>> getAuthors() {
        return this.getContainer().map(modContainer -> modContainer.getMetadata().getAuthors());
    }

    public Optional<ContactInformation> getContact() {
        return this.getContainer().map(modContainer -> modContainer.getMetadata().getContact());
    }

    public String getHomepage() {
        Optional property;
        Optional<ContactInformation> contact = this.getContact();
        String homepage = "";
        if (contact.isPresent() && (property = contact.get().get("homepage")).isPresent()) {
            homepage = (String)property.get();
        }
        return homepage;
    }
}

