/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.platform.builder;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.villagerunknown.platform.Platform;
import me.villagerunknown.platform.util.FileUtil;
import me.villagerunknown.platform.util.GsonUtil;
import me.villagerunknown.platform.util.ListUtil;

public class StringsMapBuilder {
    private String fileName;
    private List<String> defaultList;
    private Map<String, String> STRINGS;

    public StringsMapBuilder(List<String> strings) {
        this.defaultList = strings;
        this.load();
    }

    public StringsMapBuilder(String fileName, List<String> defaultList) {
        this.fileName = fileName;
        this.defaultList = defaultList;
        this.load();
    }

    public void load() {
        if (!this.fileName.isEmpty()) {
            this.loadStringsFromFile(this.fileName, this.defaultList);
        } else {
            this.STRINGS = new HashMap<String, String>();
            for (String string : this.defaultList) {
                this.STRINGS.putIfAbsent(string, string);
            }
        }
    }

    private Map<String, String> loadStringsFromFile(String fileName, List<String> defaultList) {
        Path filePath = FileUtil.getConfigPath(fileName);
        File file = filePath.toFile();
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                Gson gson = GsonUtil.gsonForFiles();
                this.STRINGS = (Map)gson.fromJson((Reader)reader, new TypeToken<Map<String, String>>(this){}.getType());
                if (this.STRINGS == null || this.STRINGS.isEmpty()) {
                    Platform.LOGGER.info(Platform.MOD_ID + " no strings found in: " + fileName);
                } else {
                    Platform.LOGGER.info(this.STRINGS.size() + " strings found in: " + fileName);
                }
            }
            catch (Exception e) {
                Platform.LOGGER.error(Platform.MOD_ID + " Error: " + e.getMessage(), (Throwable)e);
            }
        } else {
            Platform.LOGGER.info(Platform.MOD_ID + " failed to load file: " + fileName);
            this.STRINGS = new HashMap<String, String>();
            for (String string : defaultList) {
                this.STRINGS.putIfAbsent(string, string);
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String json = gson.toJson(this.STRINGS);
            try {
                Files.write(filePath, json.getBytes(), new OpenOption[0]);
                Platform.LOGGER.info(Platform.MOD_ID + " created file: " + fileName);
            }
            catch (IOException e) {
                Platform.LOGGER.error(Platform.MOD_ID + " Error: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.STRINGS;
    }

    public Map<String, String> getMap() {
        return this.STRINGS;
    }

    public String getRandomString() {
        return ListUtil.chooseRandomFromList(this.STRINGS.values().stream().toList());
    }

    public String getString(String key) {
        if (this.STRINGS.containsKey(key)) {
            return this.STRINGS.get(key);
        }
        return key;
    }
}

