/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.platform.feature;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashMap;
import java.util.Map;
import me.villagerunknown.platform.Platform;
import me.villagerunknown.platform.cmd.helpCommand;
import me.villagerunknown.platform.cmd.reloadCommand;
import me.villagerunknown.platform.cmd.worldspawnCommand;
import me.villagerunknown.platform.util.EntityUtil;
import me.villagerunknown.platform.util.MessageUtil;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7157;

public class commandsFeature {
    private static final Map<String, Runnable> COMMANDS = new HashMap<String, Runnable>();
    private static final String COMMAND_PREFIX = Platform.MOD_ID + "-";
    public static class_2168 COMMAND_SOURCE;

    public static void execute() {
        commandsFeature.addCommand("help", helpCommand::execute);
        commandsFeature.addCommand("reload", reloadCommand::execute);
        commandsFeature.addCommand("worldspawn", worldspawnCommand::execute);
        CommandRegistrationCallback.EVENT.register(commandsFeature::registerCommands);
    }

    public static void addCommand(String command, Runnable executable) {
        COMMANDS.put(command, executable);
        Platform.LOGGER.info("Command added: {}", (Object)(COMMAND_PREFIX + command));
    }

    private static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
        for (Map.Entry<String, Runnable> entry : COMMANDS.entrySet()) {
            String command = entry.getKey();
            Runnable method = entry.getValue();
            commandsFeature.registerCommand(command, method, dispatcher, registryAccess, registrationEnvironment);
        }
    }

    private static void registerCommand(String command, Runnable method, CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 registrationEnvironment) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)(COMMAND_PREFIX + command)).executes(context -> {
            COMMAND_SOURCE = (class_2168)context.getSource();
            if (Platform.CONFIG.enableCommands) {
                try {
                    method.run();
                }
                catch (Exception e) {
                    commandsFeature.sendCommandFeedback(command + " command encountered an error!", class_3417.field_15008);
                }
            } else {
                commandsFeature.sendCommandFeedback(Platform.MOD.getName() + " commands are currently disabled in the config!", class_3417.field_15008);
                Platform.LOGGER.info("Tried to execute the `{}` command but {} commands are currently disabled in the config!", (Object)(COMMAND_PREFIX + command), (Object)Platform.MOD.getName());
            }
            return 1;
        }));
        Platform.LOGGER.info("Command registered: {}", (Object)(COMMAND_PREFIX + command));
    }

    public static void sendCommandFeedback(String message, class_3414 sound) {
        commandsFeature.sendMessage(message);
        commandsFeature.playSound(sound);
    }

    public static void sendMessage(String message) {
        if (null != COMMAND_SOURCE) {
            COMMAND_SOURCE.method_45068(class_2561.method_30163((String)MessageUtil.formComment(message)));
        }
    }

    public static void playSound(class_3414 sound) {
        class_3222 player;
        if (Platform.CONFIG.enableCommandFeedbackSounds && null != COMMAND_SOURCE && null != (player = COMMAND_SOURCE.method_44023())) {
            EntityUtil.playSound((class_1297)player, sound, class_3419.field_15254, 1.0f, 1.0f, true);
        }
    }
}

