/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.platform.util;

import java.util.List;
import java.util.Objects;
import me.villagerunknown.platform.util.ExplosionUtil;
import me.villagerunknown.platform.util.LanguageUtil;
import me.villagerunknown.platform.util.MessageUtil;
import me.villagerunknown.platform.util.PositionUtil;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class EntityUtil {
    public static String formActionMessage(class_1297 entity, class_1297 damageSourceEntity, String action) {
        String giverName = damageSourceEntity instanceof class_1657 ? damageSourceEntity.method_5820() : LanguageUtil.translateToString(damageSourceEntity.method_5864().method_5882());
        String receiverName = entity.method_16914() ? entity.method_5797().getString() : LanguageUtil.translateToString(entity.method_5864().method_5882());
        String message = null == receiverName ? giverName + " " + action : giverName + " " + action + " " + receiverName;
        return message + " [" + entity.method_23317() + " " + entity.method_23318() + " " + entity.method_23321() + "]";
    }

    public static void reportAttackToLog(Logger logger, class_1297 entity, class_1297 damageSourceEntity) {
        logger.info(EntityUtil.formActionMessage(entity, damageSourceEntity, "attacked"));
    }

    public static void reportAttackToChat(class_3222 entity, class_1297 damageSourceEntity) {
        MinecraftServer server = entity.method_5682();
        if (null != server) {
            MessageUtil.broadcastChatMessage(server, EntityUtil.formActionMessage((class_1297)entity, damageSourceEntity, "attacked"));
        }
    }

    public static void reportKillToLog(Logger logger, class_1297 entity, class_1297 damageSourceEntity) {
        logger.info(EntityUtil.formActionMessage(entity, damageSourceEntity, "killed"));
    }

    public static void reportKillToChat(class_3222 entity, class_1297 damageSourceEntity) {
        MinecraftServer server = entity.method_5682();
        if (null != server) {
            MessageUtil.broadcastChatMessage(server, EntityUtil.formActionMessage((class_1297)entity, damageSourceEntity, "killed"));
        }
    }

    public static void reportConversionToLog(Logger logger, class_1297 entity, class_1297 damageSourceEntity) {
        logger.info(EntityUtil.formActionMessage(entity, damageSourceEntity, "converted"));
    }

    public static void reportConversionToChat(class_3222 entity, class_1297 damageSourceEntity) {
        MinecraftServer server = entity.method_5682();
        if (null != server) {
            MessageUtil.broadcastChatMessage(server, EntityUtil.formActionMessage((class_1297)entity, damageSourceEntity, "converted"));
        }
    }

    public static void setHealthToMax(class_1309 entity) {
        entity.method_6033(entity.method_6063());
    }

    public static boolean hasCustomName(class_1297 entity) {
        return entity.method_5797() != null && !entity.method_5797().getString().isEmpty();
    }

    public static void teleport(class_1297 entity, class_243 newPos) {
        entity.method_5808(newPos.field_1352, newPos.field_1351, newPos.field_1350, entity.method_36454(), entity.method_36455());
    }

    public static List<class_2248> getNearbyBlocks(class_1297 entity, int proximity) {
        return PositionUtil.getNearbyBlocks(entity.method_5770(), entity.method_24515(), proximity);
    }

    public static void causeExplosion(class_1937 world, class_1297 entity, float power, boolean createFire, boolean breakBlocks) {
        ExplosionUtil.causeExplosion(world, entity, power, createFire, breakBlocks);
    }

    public static void playSound(class_1297 entity, class_3414 sound, class_3419 category, float volume, float pitch, boolean toPlayer) {
        if (entity.method_31747()) {
            class_3222 player = (class_3222)entity;
            if (toPlayer) {
                player.method_17356(sound, category, volume, pitch);
            } else {
                player.method_17356(sound, category, volume, pitch);
                player.method_5783(sound, volume, pitch);
            }
        } else {
            entity.method_5783(sound, volume, pitch);
        }
    }

    public static void spawnParticles(class_1297 entity, float heightAdjust, class_2394 particle, int count, double deltaX, double deltaY, double deltaZ, double speed) {
        class_3218 serverWorld = Objects.requireNonNull(entity.method_5682()).method_3847(entity.method_37908().method_27983());
        if (null != serverWorld) {
            serverWorld.method_14199(particle, entity.method_23317(), entity.method_23318() + (double)heightAdjust, entity.method_23321(), count, deltaX, deltaY, deltaZ, speed);
        }
    }

    public static void addStatusEffect(class_1309 entity, class_6880 statusEffect, Integer duration, Integer level, Boolean ambient, Boolean particles, Boolean icon) {
        class_1293 effectInstance = new class_1293(statusEffect, duration.intValue(), level.intValue(), ambient.booleanValue(), particles.booleanValue(), icon.booleanValue());
        entity.method_6092(effectInstance);
    }

    public static void removeStatusEffect(class_1309 entity, class_6880 statusEffect) {
        entity.method_6016(statusEffect);
    }

    public static void simulateDeath(class_1309 entity) {
        EntityUtil.addStatusEffect(entity, class_1294.field_5905, 7, 1, false, false, false);
        EntityUtil.spawnParticles((class_1297)entity, 1.0f, (class_2394)class_2398.field_11204.method_29140(), 20, 0.1, 0.1, 0.1, 0.005);
    }
}

