/*
 * Decompiled with CFR 0.152.
 */
package me.villagerunknown.platform.util;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import me.villagerunknown.platform.util.RegistryUtil;
import net.minecraft.class_1646;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3852;
import net.minecraft.class_6880;
import net.minecraft.class_9306;

public class VillagerUtil {
    public static final int DEFAULT_MAX_USES = 12;
    public static final int COMMON_MAX_USES = 16;
    public static final int RARE_MAX_USES = 3;
    public static final int NOVICE_SELL_XP = 1;
    public static final int NOVICE_BUY_XP = 2;
    public static final int APPRENTICE_SELL_XP = 5;
    public static final int APPRENTICE_BUY_XP = 10;
    public static final int JOURNEYMAN_SELL_XP = 10;
    public static final int JOURNEYMAN_BUY_XP = 20;
    public static final int EXPERT_SELL_XP = 15;
    public static final int EXPERT_BUY_XP = 30;
    public static final int MASTER_TRADE_XP = 30;
    public static final float LOW_PRICE_MULTIPLIER = 0.05f;
    public static final float HIGH_PRICE_MULTIPLIER = 0.2f;

    public static class_1914 buyTradeOffer(int level, class_9306 demand, class_1799 supply) {
        return new class_1914(demand, supply, VillagerUtil.getMaxTrades(level), VillagerUtil.getTradeXp(level, "buy"), VillagerUtil.getTradeMultiplier(level));
    }

    public static class_1914 buyTradeOffer(int level, class_9306 demand, class_9306 demand2, class_1799 supply) {
        return new class_1914(demand, Optional.of(demand2), supply, VillagerUtil.getMaxTrades(level), VillagerUtil.getTradeXp(level, "buy"), VillagerUtil.getTradeMultiplier(level));
    }

    public static class_1914 buyTradeOffer(int level, class_1792 costItem, int costAmount, class_1792 saleItem, int saleAmount) {
        class_9306 demand = new class_9306((class_1935)costItem, costAmount);
        class_1799 supply = new class_1799((class_1935)saleItem, saleAmount);
        return new class_1914(demand, supply, VillagerUtil.getMaxTrades(level), VillagerUtil.getTradeXp(level, "buy"), VillagerUtil.getTradeMultiplier(level));
    }

    public static class_1914 buyTradeOffer(int level, class_1792 costItem, int costAmount, class_1792 costItem2, int costAmount2, class_1792 saleItem, int saleAmount) {
        class_9306 demand = new class_9306((class_1935)costItem, costAmount);
        class_9306 demand2 = new class_9306((class_1935)costItem2, costAmount2);
        class_1799 supply = new class_1799((class_1935)saleItem, saleAmount);
        return new class_1914(demand, Optional.of(demand2), supply, VillagerUtil.getMaxTrades(level), VillagerUtil.getTradeXp(level, "buy"), VillagerUtil.getTradeMultiplier(level));
    }

    public static class_1914 sellTradeOffer(int level, class_9306 demand, class_1799 supply) {
        return new class_1914(demand, supply, VillagerUtil.getMaxTrades(level), VillagerUtil.getTradeXp(level, "sell"), VillagerUtil.getTradeMultiplier(level));
    }

    public static class_1914 sellTradeOffer(int level, class_9306 demand, class_9306 demand2, class_1799 supply) {
        return new class_1914(demand, Optional.of(demand2), supply, VillagerUtil.getMaxTrades(level), VillagerUtil.getTradeXp(level, "sell"), VillagerUtil.getTradeMultiplier(level));
    }

    public static class_1914 sellTradeOffer(int level, class_1792 costItem, int costAmount, class_1792 saleItem, int saleAmount) {
        class_9306 demand = new class_9306((class_1935)costItem, costAmount);
        class_1799 supply = new class_1799((class_1935)saleItem, saleAmount);
        return new class_1914(demand, supply, VillagerUtil.getMaxTrades(level), VillagerUtil.getTradeXp(level, "sell"), VillagerUtil.getTradeMultiplier(level));
    }

    public static class_1914 sellTradeOffer(int level, class_1792 costItem, int costAmount, class_1792 costItem2, int costAmount2, class_1792 saleItem, int saleAmount) {
        class_9306 demand = new class_9306((class_1935)costItem, costAmount);
        class_9306 demand2 = new class_9306((class_1935)costItem2, costAmount2);
        class_1799 supply = new class_1799((class_1935)saleItem, saleAmount);
        return new class_1914(demand, Optional.of(demand2), supply, VillagerUtil.getMaxTrades(level), VillagerUtil.getTradeXp(level, "sell"), VillagerUtil.getTradeMultiplier(level));
    }

    public static int getMaxTrades(int level) {
        return switch (level) {
            case 5 -> 3;
            case 3, 4 -> 16;
            default -> 12;
        };
    }

    public static int getTradeXp(int level, String type) {
        return switch (level) {
            case 5 -> 30;
            case 4 -> {
                if (Objects.equals(type, "buy")) {
                    yield 30;
                }
                yield 15;
            }
            case 3 -> {
                if (Objects.equals(type, "buy")) {
                    yield 20;
                }
                yield 10;
            }
            case 2 -> {
                if (Objects.equals(type, "buy")) {
                    yield 10;
                }
                yield 5;
            }
            default -> Objects.equals(type, "buy") ? 2 : 1;
        };
    }

    public static float getTradeMultiplier(int level) {
        return switch (level) {
            case 5 -> 0.2f;
            default -> 0.05f;
        };
    }

    public static void resetTrades(class_1646 villager) {
        villager.method_16917(null);
        int level = villager.method_7231().method_16925();
        class_1916 offers = new class_1916();
        for (int i = 1; i <= level; ++i) {
            villager.method_7195(villager.method_7231().method_16920(i));
            offers.addAll((Collection)villager.method_8264());
            villager.method_16917(null);
        }
        villager.method_16917(offers);
    }

    public static class CustomVillager {
        public class_2960 IDENTIFIER;
        public ImmutableList<class_2680> WORKSTATIONS;
        public class_3414 SOUND;
        public class_6880<class_3852> REGISTRY_ENTRY;
        public class_3852 PROFESSION;

        public CustomVillager(class_2960 id, ImmutableList<class_2680> workstations, String professionKey, class_3414 workSound) {
            this.IDENTIFIER = id;
            this.WORKSTATIONS = workstations;
            this.SOUND = workSound;
            this.REGISTRY_ENTRY = RegistryUtil.registerVillager(id, workstations, professionKey, workSound);
            this.PROFESSION = (class_3852)this.REGISTRY_ENTRY.comp_349();
        }
    }
}

