/*
 * Decompiled with CFR 0.152.
 */
package dev.penguinspy.thinner_air.airquality;

import net.minecraft.class_3542;
import org.jetbrains.annotations.Nullable;

public enum AirQuality implements class_3542
{
    GREEN("green", 3),
    YELLOW("yellow", 1),
    RED("red", 0),
    BLUE("blue", 2);

    private final String name;
    private final int level;
    public static final class_3542.class_7292<AirQuality> CODEC;

    private AirQuality(String name, int level) {
        this.name = name;
        this.level = level;
    }

    public int level() {
        return this.level;
    }

    public static AirQuality fromLevel(int level) {
        return switch (level) {
            case 0 -> RED;
            case 1 -> YELLOW;
            case 2 -> BLUE;
            case 3 -> GREEN;
            default -> throw new IllegalArgumentException("air quality out of bounds [0,3]: " + level);
        };
    }

    static AirQuality bestOf(AirQuality left, @Nullable AirQuality right) {
        return right == null ? left : (left.level > right.level ? left : right);
    }

    public String method_15434() {
        return this.name;
    }

    public static AirQuality fromString(String name) {
        return switch (name) {
            case "red" -> RED;
            case "yellow" -> YELLOW;
            case "blue" -> BLUE;
            case "green" -> GREEN;
            default -> throw new IllegalArgumentException("unknown air quality name: " + name);
        };
    }

    static {
        CODEC = class_3542.method_28140(AirQuality::values);
    }
}

