/*
 * Decompiled with CFR 0.152.
 */
package dev.penguinspy.thinner_air.airquality;

import dev.penguinspy.thinner_air.airquality.AirQuality;
import dev.penguinspy.thinner_air.airquality.AirQualityEmittersComponent;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_7225;

public class AirQualityEmittersComponentImplementation
implements AirQualityEmittersComponent {
    private static final String EMITTERS_MAP_KEY = "emitters";
    private final Map<class_2338, AirQuality> airQualityEmitters = new HashMap<class_2338, AirQuality>();
    private final class_2791 chunk;

    public AirQualityEmittersComponentImplementation(class_2791 provider) {
        this.chunk = provider;
    }

    @Override
    public void put(class_2338 pos, AirQuality quality) {
        this.airQualityEmitters.put(pos, quality);
        this.chunk.method_12008(true);
    }

    @Override
    public void remove(class_2338 pos) {
        if (this.airQualityEmitters.remove(pos) != null) {
            this.chunk.method_12008(true);
        }
    }

    @Override
    public Map<class_2338, AirQuality> getAirQualityEmitters() {
        return this.airQualityEmitters;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.airQualityEmitters.clear();
        ByteBuffer buffer = ByteBuffer.wrap(tag.method_10547(EMITTERS_MAP_KEY));
        while (buffer.hasRemaining()) {
            class_2338 position = class_2338.method_10092((long)buffer.getLong());
            AirQuality quality = AirQuality.fromLevel(buffer.get());
            this.airQualityEmitters.put(position, quality);
        }
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        ByteBuffer buffer = ByteBuffer.allocate(this.airQualityEmitters.size() * 9);
        for (Map.Entry<class_2338, AirQuality> entry : this.airQualityEmitters.entrySet()) {
            buffer.putLong(entry.getKey().method_10063());
            buffer.put((byte)entry.getValue().level());
        }
        tag.method_10570(EMITTERS_MAP_KEY, buffer.array());
    }
}

